/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.RowProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfLabel {
    protected static Category log = ThreadCategory.getInstance(IfLabel.class);

    public static Map<String, String> getInterfaceInfoFromIfLabel(int nodeId, String ifLabel) {
        if (ifLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        final HashMap<String, String> info = new HashMap<String, String>();
        String desc = ifLabel;
        String mac = null;
        int dashIndex = ifLabel.lastIndexOf("-");
        if (dashIndex >= 0) {
            desc = ifLabel.substring(0, dashIndex);
            mac = ifLabel.substring(dashIndex + 1, ifLabel.length());
        }
        final String desc2 = desc;
        final String mac2 = mac;
        log.debug((Object)("getInterfaceInfoFromIfLabel: desc=" + desc + " mac=" + mac));
        String queryDesc = desc.replace('_', '%');
        String query = "SELECT *   FROM snmpinterface  WHERE nodeid = " + nodeId + "   AND (snmpifdescr ILIKE '" + queryDesc + "'" + "    OR snmpifname ilike '" + queryDesc + "')";
        log.debug((Object)("getInterfaceInfoFromLabel: query is: " + query));
        Querier q = new Querier(Vault.getDataSource(), query, new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                if (rs.getString("snmpifdescr") != null && Pattern.matches(".*-cef.*", rs.getString("snmpifdescr"))) {
                    return;
                }
                if ((AlphaNumeric.parseAndReplace((String)rs.getString("snmpifname"), (char)'_').equals(desc2) || AlphaNumeric.parseAndReplace((String)rs.getString("snmpifdescr"), (char)'_').equals(desc2)) && (mac2 == null || mac2.equals(rs.getString("snmpphysaddr")))) {
                    ThreadCategory.getInstance(IfLabel.class).debug((Object)"getInterfaceInfoFromIfLabel: found match...");
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        info.put(rs.getMetaData().getColumnName(i), rs.getString(i));
                    }
                }
            }
        });
        q.execute();
        log.debug((Object)("getInterfaceInfoFromLabel: Querier result count is: " + q.getCount()));
        return info;
    }

    public static String[] getIfLabels(int nodeId) throws SQLException {
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface, ipinterface  WHERE (ipinterface.ismanaged!='D')    AND ipinterface.nodeid=snmpinterface.nodeid    AND ifindex = snmpifindex    AND ipinterface.nodeid=" + nodeId;
        final ArrayList list = new ArrayList();
        Querier q = new Querier(Vault.getDataSource(), query, new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                list.add(IfLabel.getIfLabel(name, descr, physAddr));
            }
        });
        q.execute();
        String[] labels = list.toArray(new String[list.size()]);
        return labels;
    }

    public static String getIfLabel(final int nodeId, final String ipAddr) {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String inetAddr = InetAddressUtils.getInetAddress((String)ipAddr).getHostAddress();
        class LabelHolder {
            private String m_label;

            LabelHolder() {
            }

            public void setLabel(String label) {
                this.m_label = label;
            }

            public String getLabel() {
                return this.m_label;
            }
        }
        final LabelHolder holder = new LabelHolder();
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface, ipinterface  WHERE (ipinterface.ismanaged!='D')    AND ipinterface.nodeid=snmpinterface.nodeid    AND ifindex=snmpifindex    AND ipinterface.nodeid = " + nodeId + "   AND ipinterface.ipaddr = '" + inetAddr + "'";
        Querier q = new Querier(Vault.getDataSource(), query, new RowProcessor(){
            {
            }

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    holder.setLabel(IfLabel.getIfLabel(name, descr, physAddr));
                } else {
                    log.warn((Object)("Interface (nodeId/ipAddr=" + nodeId + "/" + ipAddr + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'."));
                    holder.setLabel("no_ifLabel");
                }
            }
        });
        q.execute();
        return holder.getLabel();
    }

    public static String getIfLabelfromIfIndex(final int nodeId, final String ipAddr, int ifIndex) {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String inetAddr = InetAddressUtils.getInetAddress((String)ipAddr).getHostAddress();
        if (ifIndex == -1) {
            return IfLabel.getIfLabel(nodeId, inetAddr);
        }
        class LabelHolder {
            private String m_label;

            LabelHolder() {
            }

            public void setLabel(String label) {
                this.m_label = label;
            }

            public String getLabel() {
                return this.m_label;
            }
        }
        final LabelHolder holder = new LabelHolder();
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface, ipinterface  WHERE (ipinterface.ismanaged!='D')    AND ipinterface.nodeid=snmpinterface.nodeid    AND ifindex=snmpifindex    AND ipinterface.nodeid= " + nodeId + "   AND ipinterface.ipaddr= '" + inetAddr + "'" + "   AND ipinterface.ifindex= " + ifIndex;
        Querier q = new Querier(Vault.getDataSource(), query, new RowProcessor(){
            {
            }

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    holder.setLabel(IfLabel.getIfLabel(name, descr, physAddr));
                } else {
                    log.warn((Object)("Interface (nodeId/ipAddr=" + nodeId + "/" + ipAddr + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'."));
                    holder.setLabel("no_ifLabel");
                }
            }
        });
        q.execute();
        return holder.getLabel();
    }

    public static String getIfLabelfromSnmpIfIndex(final int nodeId, final int ifIndex) {
        class LabelHolder {
            private String m_label;

            LabelHolder() {
            }

            public void setLabel(String label) {
                this.m_label = label;
            }

            public String getLabel() {
                return this.m_label;
            }
        }
        final LabelHolder holder = new LabelHolder();
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface    WHERE nodeid= " + nodeId + "   AND snmpifindex= " + ifIndex;
        Querier q = new Querier(Vault.getDataSource(), query, new RowProcessor(){
            {
            }

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    holder.setLabel(IfLabel.getIfLabel(name, descr, physAddr));
                } else {
                    log.warn((Object)("Interface (nodeId/ifIndex=" + nodeId + "/" + ifIndex + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'."));
                    holder.setLabel("no_ifLabel");
                }
            }
        });
        q.execute();
        return holder.getLabel();
    }

    public static String getIfLabel(String name, String descr, String physAddr) {
        String label = null;
        if (name != null) {
            label = AlphaNumeric.parseAndReplace((String)name, (char)'_');
        } else if (descr != null) {
            label = AlphaNumeric.parseAndReplace((String)descr, (char)'_');
        } else {
            throw new IllegalArgumentException("Both name and descr are null, but at least one cannot be.");
        }
        if (physAddr != null) {
            if ((physAddr = AlphaNumeric.parseAndTrim((String)physAddr)).length() == 12) {
                label = label + "-" + physAddr;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("initialize: physical address len is NOT 12, physAddr=" + physAddr));
            }
        }
        return label;
    }
}

