/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.trapd.BroadcastEventProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trapd
extends AbstractServiceDaemon
implements PausableFiber,
TrapProcessorFactory,
TrapNotificationListener,
InitializingBean {
    private int m_status = 0;
    private FifoQueue<TrapNotification> m_backlogQ;
    private TrapQueueProcessor m_processor;
    private BroadcastEventProcessor m_eventReader;
    private TrapdIpMgr m_trapdIpMgr;
    private Integer m_snmpTrapPort;
    private boolean m_registeredForTraps;

    public Trapd() {
        super("OpenNMS.Trapd");
    }

    public TrapProcessor createTrapProcessor() {
        return new EventCreator(this.m_trapdIpMgr);
    }

    public void trapReceived(TrapNotification trapNotification) {
        this.addTrap(trapNotification);
    }

    private void addTrap(TrapNotification o) {
        try {
            this.m_backlogQ.add((Object)o);
        }
        catch (InterruptedException e) {
            this.log().warn((Object)"snmpReceivedTrap: Error adding trap to queue, it was interrupted", (Throwable)e);
        }
        catch (FifoQueueException e) {
            this.log().warn((Object)"snmpReceivedTrap: Error adding trap to queue", (Throwable)e);
        }
    }

    public synchronized void onInit() {
        Assert.state((this.m_trapdIpMgr != null ? 1 : 0) != 0, (String)"trapdIpMgr must be set");
        Assert.state((this.m_eventReader != null ? 1 : 0) != 0, (String)"eventReader must be set");
        Assert.state((this.m_backlogQ != null ? 1 : 0) != 0, (String)"backlogQ must be set");
        Assert.state((this.m_snmpTrapPort != null ? 1 : 0) != 0, (String)"snmpTrapPort must be set");
        Assert.state((this.m_processor != null ? 1 : 0) != 0, (String)"processor must be set");
        try {
            this.m_trapdIpMgr.dataSourceSync();
        }
        catch (SQLException e) {
            this.log().error((Object)("Failed to load known IP address list: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (TrapProcessorFactory)this, (int)this.getSnmpTrapPort());
            this.m_registeredForTraps = true;
            this.log().debug((Object)"start: Creating the trap session");
        }
        catch (IOException e) {
            this.log().error((Object)"Failed to setup SNMP trap port", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            this.m_eventReader.open();
        }
        catch (Exception e) {
            this.log().error((Object)("Failed to open event reader: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public synchronized void onStart() {
        this.m_status = 1;
        this.log().debug((Object)"start: Initializing the trapd config factory");
        this.m_processor.start();
        this.m_status = 2;
        this.log().debug((Object)"start: Trapd ready to receive traps");
    }

    public void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        this.log().debug((Object)"Calling pause on processor");
        this.m_processor.pause();
        this.log().debug((Object)"Processor paused");
        this.m_status = 6;
        this.log().debug((Object)"Trapd paused");
    }

    public void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        this.log().debug((Object)"Calling resume on processor");
        this.m_processor.resume();
        this.log().debug((Object)"Processor resumed");
        this.m_status = 2;
        this.log().debug((Object)"Trapd resumed");
    }

    public synchronized void onStop() {
        this.m_status = 3;
        this.log().debug((Object)"exit: closing communication paths.");
        try {
            if (this.m_registeredForTraps) {
                this.log().debug((Object)"stop: Closing SNMP trap session.");
                SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (int)this.getSnmpTrapPort());
                this.log().debug((Object)"stop: SNMP trap session closed.");
            } else {
                this.log().debug((Object)"stop: not attemping to closing SNMP trap session--it was never opened");
            }
        }
        catch (IOException e) {
            this.log().warn((Object)("stop: exception occurred closing session: " + e), (Throwable)e);
        }
        catch (IllegalStateException e) {
            this.log().debug((Object)"stop: The SNMP session was already closed");
        }
        this.log().debug((Object)"stop: Stopping queue processor.");
        this.m_processor.stop();
        this.m_eventReader.close();
        this.m_status = 4;
        this.log().debug((Object)"stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public void trapError(int error, String msg) {
        this.log().warn((Object)("Error Processing Received Trap: error = " + error + (msg != null ? ", ref = " + msg : "")));
    }

    public TrapdIpMgr getTrapdIpMgr() {
        return this.m_trapdIpMgr;
    }

    public void setTrapdIpMgr(TrapdIpMgr trapdIpMgr) {
        this.m_trapdIpMgr = trapdIpMgr;
    }

    public BroadcastEventProcessor getEventReader() {
        return this.m_eventReader;
    }

    public void setEventReader(BroadcastEventProcessor eventReader) {
        this.m_eventReader = eventReader;
    }

    public FifoQueue<TrapNotification> getBacklogQ() {
        return this.m_backlogQ;
    }

    public void setBacklogQ(FifoQueue<TrapNotification> backlogQ) {
        this.m_backlogQ = backlogQ;
    }

    public TrapQueueProcessor getProcessor() {
        return this.m_processor;
    }

    public void setProcessor(TrapQueueProcessor processor) {
        this.m_processor = processor;
    }

    public int getSnmpTrapPort() {
        return this.m_snmpTrapPort;
    }

    public void setSnmpTrapPort(int snmpTrapPort) {
        this.m_snmpTrapPort = snmpTrapPort;
    }
}

