/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.trapd.SyntaxToEvent;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;

public class EventCreator
implements TrapProcessor {
    private Event m_event;
    private Snmp m_snmpInfo;
    private Parms m_parms;
    private TrapdIpMgr m_trapdIpMgr;

    EventCreator(TrapdIpMgr trapdIpMgr) {
        this.m_trapdIpMgr = trapdIpMgr;
        this.m_event = new Event();
        this.m_event.setSource("trapd");
        this.m_event.setTime(EventConstants.formatToString((Date)new Date()));
        this.m_snmpInfo = new Snmp();
        this.m_event.setSnmp(this.m_snmpInfo);
        this.m_parms = new Parms();
        this.m_event.setParms(this.m_parms);
    }

    public void setCommunity(String community) {
        this.m_snmpInfo.setCommunity(community);
    }

    public void setTimeStamp(long timeStamp) {
        this.m_snmpInfo.setTimeStamp(timeStamp);
    }

    public void setVersion(String version) {
        this.m_snmpInfo.setVersion(version);
    }

    private void setGeneric(int generic) {
        this.m_snmpInfo.setGeneric(generic);
    }

    private void setSpecific(int specific) {
        this.m_snmpInfo.setSpecific(specific);
    }

    private void setEnterpriseId(String enterpriseId) {
        this.m_snmpInfo.setId(enterpriseId);
    }

    public void setAgentAddress(InetAddress agentAddress) {
        this.m_event.setHost(agentAddress.getHostAddress());
    }

    public void processVarBind(SnmpObjId name, SnmpValue value) {
        this.m_parms.addParm(SyntaxToEvent.processSyntax(name.toString(), value));
        if (org.opennms.netmgt.trapd.EventConstants.OID_SNMP_IFINDEX.isPrefixOf(name)) {
            this.m_event.setIfIndex(value.toInt());
        }
    }

    public void setTrapAddress(InetAddress trapAddress) {
        String trapInterface = trapAddress.getHostAddress();
        this.m_event.setSnmphost(trapInterface);
        this.m_event.setInterface(trapInterface);
        long nodeId = this.m_trapdIpMgr.getNodeId(trapInterface);
        if (nodeId != -1L) {
            this.m_event.setNodeid(nodeId);
        }
    }

    public void setTrapIdentity(TrapIdentity trapIdentity) {
        this.setGeneric(trapIdentity.getGeneric());
        this.setSpecific(trapIdentity.getSpecific());
        this.setEnterpriseId(trapIdentity.getEnterpriseId().toString());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("snmp trap " + trapIdentity));
        }
    }

    Event getEvent() {
        return this.m_event;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

