/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.translator.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.EventTranslatorConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.translator.jmx.EventTranslatorMBean;

public class EventTranslator
implements EventTranslatorMBean {
    public static final String LOG4J_CATEGORY = "OpenNMS.EventTranslator";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Logger log = ThreadCategory.getInstance();
        try {
            DataSourceFactory.init();
            EventTranslatorConfigFactory.init();
        }
        catch (MarshalException e) {
            log.error((Object)"Could not unmarshall configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            log.error((Object)"validation error ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            log.error((Object)"IOException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to initialize database: " + e.getMessage()), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.error((Object)"SQLException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            log.error((Object)"PropertyVetoException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        org.opennms.netmgt.translator.EventTranslator keeper = this.getEventTranslator();
        keeper.setConfig(EventTranslatorConfigFactory.getInstance());
        keeper.setEventManager(mgr);
        keeper.setDataSource(DataSourceFactory.getInstance());
        keeper.init();
    }

    public void start() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getEventTranslator().start();
    }

    public void stop() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getEventTranslator().stop();
    }

    public int getStatus() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return this.getEventTranslator().getStatus();
    }

    public String status() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    private org.opennms.netmgt.translator.EventTranslator getEventTranslator() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return org.opennms.netmgt.translator.EventTranslator.getInstance();
    }
}

