/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.translator;

import java.util.List;
import javax.sql.DataSource;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.config.EventTranslatorConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;

public class EventTranslator
extends AbstractServiceDaemon
implements EventListener {
    private static EventTranslator s_instance = new EventTranslator();
    private volatile EventIpcManager m_eventMgr;
    private volatile EventTranslatorConfig m_config;
    private volatile boolean m_initialized = false;
    private DataSource m_dataSource;

    public EventTranslator() {
        super("OpenNMS.EventTranslator");
    }

    public EventTranslator(EventIpcManager eventMgr) {
        this();
        this.setEventManager(eventMgr);
    }

    public static synchronized void setInstance(EventTranslator psk) {
        s_instance = psk;
    }

    public static synchronized EventTranslator getInstance() {
        return s_instance;
    }

    protected void onInit() {
        if (this.m_initialized) {
            return;
        }
        this.checkPreRequisites();
        this.createMessageSelectorAndSubscribe();
        this.m_initialized = true;
    }

    private void checkPreRequisites() {
        if (this.m_config == null) {
            throw new IllegalStateException("config has not been set");
        }
        if (this.m_eventMgr == null) {
            throw new IllegalStateException("eventManager has not been set");
        }
        if (this.m_dataSource == null) {
            throw new IllegalStateException("dataSource has not been set");
        }
    }

    protected void onStop() {
        this.m_initialized = false;
        this.m_eventMgr = null;
        this.m_config = null;
    }

    private void createMessageSelectorAndSubscribe() {
        List<String> ueiList = this.m_config.getUEIList();
        ueiList.add("uei.opennms.org/internal/reloadDaemonConfig");
        this.getEventManager().addEventListener(this, ueiList);
    }

    public void onEvent(Event e) {
        if (this.isReloadConfigEvent(e)) {
            this.handleReloadEvent(e);
            return;
        }
        if (this.getName().equals(e.getSource())) {
            this.log().debug((Object)"onEvent: ignoring event with EventTranslator as source");
            return;
        }
        if (!this.m_config.isTranslationEvent(e)) {
            this.log().debug((Object)("onEvent: received event that matches no translations: \n" + EventUtils.toString(e)));
            return;
        }
        this.log().debug((Object)("onEvent: received valid registered translation event: \n" + EventUtils.toString(e)));
        List<Event> translated = this.m_config.translateEvent(e);
        if (translated != null) {
            Log log = new Log();
            Events events = new Events();
            for (Event event : translated) {
                events.addEvent(event);
                this.log().debug((Object)("onEvent: sended translated event: \n" + EventUtils.toString(event)));
            }
            log.setEvents(events);
            this.getEventManager().sendNow(log);
        }
    }

    protected void handleReloadEvent(Event e) {
        this.log().info((Object)"onEvent: reloading configuration....");
        EventBuilder ebldr = null;
        try {
            List<String> previousUeis = this.m_config.getUEIList();
            this.m_config.update();
            this.getEventManager().removeEventListener(this, previousUeis);
            this.getEventManager().addEventListener(this, this.m_config.getUEIList());
            this.log().debug((Object)"onEvent: configuration reloaded.");
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Translator");
        }
        catch (Exception exception) {
            this.log().error((Object)("onEvent: reload config failed:" + e), (Throwable)exception);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Translator");
            ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
        }
        if (ebldr != null) {
            this.m_eventMgr.sendNow(ebldr.getEvent());
        }
        this.log().info((Object)("onEvent: reload configuration: reload configuration contains " + this.m_config.getUEIList().size() + " UEI specs."));
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParms().getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Translator".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
            this.log().debug((Object)("isReloadConfigEventTarget: Event Translator was target of reload event: " + isTarget));
        }
        return isTarget;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public EventTranslatorConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(EventTranslatorConfig config) {
        this.m_config = config;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }
}

