/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigManager;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdingEventProxyFactory;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThresholdingSet {
    int m_nodeId;
    String m_hostAddress;
    String m_serviceName;
    RrdRepository m_repository;
    ThresholdsDao m_thresholdsDao;
    ThreshdConfigManager m_configManager;
    boolean m_initialized = false;
    boolean m_hasThresholds = false;
    List<ThresholdGroup> m_thresholdGroups;
    long m_interval;

    public ThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository, long interval) {
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress;
        this.m_serviceName = serviceName;
        this.m_repository = repository;
        this.m_interval = interval / 1000L;
        this.initThresholdsDao();
        this.initialize();
    }

    protected void initialize() {
        List<String> groupNameList = this.getThresholdGroupNames(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        this.m_thresholdGroups = new LinkedList<ThresholdGroup>();
        for (String groupName : groupNameList) {
            ThresholdGroup thresholdGroup = this.m_thresholdsDao.get(groupName);
            if (thresholdGroup == null) {
                this.log().error((Object)("initialize: Could not get threshold group with name " + groupName));
            }
            this.m_thresholdGroups.add(thresholdGroup);
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug((Object)("initialize: Adding threshold group: " + thresholdGroup));
        }
        this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
    }

    public void reinitialize() {
        this.m_initialized = false;
        ThresholdingEventProxyFactory.getFactory().getProxy().removeAllEvents();
        this.initThresholdsDao();
        this.mergeThresholdGroups();
        this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        ThresholdingEventProxyFactory.getFactory().getProxy().sendAllEvents();
    }

    protected void mergeThresholdGroups() {
        this.log().debug((Object)"mergeThresholdGroups: begin merging operation");
        List<String> groupNameList = this.getThresholdGroupNames(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        if (groupNameList.size() != this.m_thresholdGroups.size()) {
            this.log().debug((Object)"mergeThresholdGroups: new group name list differs from current threshold group list");
            Iterator<ThresholdGroup> i = this.m_thresholdGroups.iterator();
            while (i.hasNext()) {
                ThresholdGroup group = i.next();
                if (groupNameList.contains(group.getName())) continue;
                this.log().info((Object)("mergeThresholdGroups: deleting group " + group));
                group.delete();
                i.remove();
            }
        }
        LinkedList<ThresholdGroup> newThresholdGroupList = new LinkedList<ThresholdGroup>();
        for (String groupName : groupNameList) {
            ThresholdGroup thresholdGroup;
            ThresholdGroup foundGroup = null;
            for (ThresholdGroup group : this.m_thresholdGroups) {
                if (!group.getName().equals(groupName)) continue;
                foundGroup = group;
            }
            if (foundGroup == null) {
                thresholdGroup = this.m_thresholdsDao.get(groupName);
                if (thresholdGroup == null) {
                    this.log().error((Object)("mergeThresholdGroups: Could not get threshold group with name " + groupName));
                    continue;
                }
                newThresholdGroupList.add(thresholdGroup);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("mergeThresholdGroups: Adding threshold group: " + thresholdGroup));
                continue;
            }
            thresholdGroup = this.m_thresholdsDao.merge(foundGroup);
            newThresholdGroupList.add(thresholdGroup);
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug((Object)("mergeThresholdGroups: Merging threshold group: " + thresholdGroup));
        }
        this.m_thresholdGroups = newThresholdGroupList;
    }

    public boolean hasThresholds() {
        return this.m_hasThresholds;
    }

    public boolean hasThresholds(String resourceTypeName, String attributeName) {
        boolean ok = false;
        for (ThresholdGroup group : this.m_thresholdGroups) {
            Map<String, Set<ThresholdEntity>> entityMap = this.getEntityMap(group, resourceTypeName);
            if (entityMap == null) continue;
            for (String key : entityMap.keySet()) {
                for (ThresholdEntity thresholdEntity : entityMap.get(key)) {
                    Collection<String> requiredDatasources = thresholdEntity.getRequiredDatasources();
                    if (!requiredDatasources.contains(attributeName)) continue;
                    ok = true;
                }
            }
        }
        this.log().debug((Object)("hasThresholds: " + resourceTypeName + "@" + attributeName + "? " + ok));
        return ok;
    }

    protected List<Event> applyThresholds(CollectionResourceWrapper resourceWrapper, Map<String, CollectionAttribute> attributesMap) {
        this.log().debug((Object)("applyThresholds: Applying thresholds on " + resourceWrapper + " using " + attributesMap.size() + " attributes."));
        Date date = new Date();
        LinkedList<Event> eventsList = new LinkedList<Event>();
        for (ThresholdGroup group : this.m_thresholdGroups) {
            Map<String, Set<ThresholdEntity>> entityMap = this.getEntityMap(group, resourceWrapper.getResourceTypeName());
            if (entityMap == null) continue;
            for (String key : entityMap.keySet()) {
                for (ThresholdEntity thresholdEntity : entityMap.get(key)) {
                    if (this.passedThresholdFilters(resourceWrapper, thresholdEntity)) {
                        this.log().info((Object)("applyThresholds: Processing threshold " + key + " : " + thresholdEntity));
                        Collection<String> requiredDatasources = thresholdEntity.getRequiredDatasources();
                        HashMap<String, Double> values = new HashMap<String, Double>();
                        boolean valueMissing = false;
                        for (String ds : requiredDatasources) {
                            Double dsValue = resourceWrapper.getAttributeValue(ds);
                            if (dsValue == null) {
                                this.log().info((Object)("applyThresholds: Could not get data source value for '" + ds + "'.  Not evaluating threshold."));
                                valueMissing = true;
                            }
                            values.put(ds, dsValue);
                        }
                        if (valueMissing) continue;
                        this.log().info((Object)"applyThresholds: All values found, evaluating");
                        resourceWrapper.setLabel(thresholdEntity.getDatasourceLabel());
                        List<Event> thresholdEvents = thresholdEntity.evaluateAndCreateEvents(resourceWrapper, values, date);
                        eventsList.addAll(thresholdEvents);
                        continue;
                    }
                    this.log().info((Object)("applyThresholds: Not processing threshold " + key + " : " + thresholdEntity + " because no filters matched"));
                }
            }
        }
        return eventsList;
    }

    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        ResourceFilter[] filters = thresholdEntity.getThresholdConfig().getBasethresholddef().getResourceFilter();
        if (filters.length == 0) {
            return true;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("passedThresholdFilters: applying " + filters.length + " filters to resource " + resource));
        }
        int count = 1;
        for (ResourceFilter f : filters) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("passedThresholdFilters: filter #" + count + ": field=" + f.getField() + ", regex='" + f.getContent() + "'"));
            }
            ++count;
            String attr = resource.getLabelValue(f.getField());
            if (attr != null) {
                try {
                    Pattern p = Pattern.compile(f.getContent());
                    Matcher m = p.matcher(attr);
                    boolean pass = m.matches();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("passedThresholdFilters: the value of " + f.getField() + " is " + attr + ". Pass filter? " + pass));
                    }
                    if (!pass) continue;
                    return true;
                }
                catch (PatternSyntaxException e) {
                    this.log().warn((Object)("passedThresholdFilters: the regular expression " + f.getContent() + " is invalid: " + e.getMessage()), (Throwable)e);
                    return false;
                }
            }
            this.log().warn((Object)("passedThresholdFilters: can't find value of " + f.getField() + " for resource " + resource));
        }
        return false;
    }

    protected void initThresholdsDao() {
        if (!this.m_initialized) {
            this.log().debug((Object)"initThresholdsDao: Initializing Factories and DAOs");
            this.m_initialized = true;
            DefaultThresholdsDao defaultThresholdsDao = new DefaultThresholdsDao();
            try {
                ThresholdingConfigFactory.init();
                defaultThresholdsDao.setThresholdingConfigFactory(ThresholdingConfigFactory.getInstance());
                defaultThresholdsDao.afterPropertiesSet();
            }
            catch (Throwable t) {
                this.log().error((Object)("initThresholdsDao: Could not initialize DefaultThresholdsDao: " + t), t);
                throw new RuntimeException("Could not initialize DefaultThresholdsDao: " + t, t);
            }
            try {
                ThreshdConfigFactory.init();
            }
            catch (Throwable t) {
                this.log().error((Object)("initThresholdsDao: Could not initialize ThreshdConfigFactory: " + t), t);
                throw new RuntimeException("Could not initialize ThreshdConfigFactory: " + t, t);
            }
            this.m_thresholdsDao = defaultThresholdsDao;
            this.m_configManager = ThreshdConfigFactory.getInstance();
        }
    }

    private List<String> getThresholdGroupNames(int nodeId, String hostAddress, String serviceName) {
        LinkedList<String> groupNameList = new LinkedList<String>();
        for (Package pkg : this.m_configManager.getConfiguration().getPackage()) {
            boolean foundInPkg;
            if (!this.m_configManager.serviceInPackageAndEnabled(serviceName, pkg)) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("getThresholdGroupNames: address/service: " + hostAddress + "/" + serviceName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName()));
                continue;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("getThresholdGroupNames: checking ipaddress " + hostAddress + " for inclusion in pkg " + pkg.getName()));
            }
            if (!(foundInPkg = this.m_configManager.interfaceInPackage(hostAddress, pkg))) {
                this.m_configManager.rebuildPackageIpListMap();
                foundInPkg = this.m_configManager.interfaceInPackage(hostAddress, pkg);
            }
            if (!foundInPkg) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("getThresholdGroupNames: address/service: " + hostAddress + "/" + serviceName + " not scheduled, interface does not belong to package: " + pkg.getName()));
                continue;
            }
            for (Service svc : pkg.getService()) {
                if (!svc.getName().equals(serviceName)) continue;
                String groupName = null;
                for (Parameter parameter : svc.getParameter()) {
                    if (!parameter.getKey().equals("thresholding-group")) continue;
                    groupName = parameter.getValue();
                }
                if (groupName == null) continue;
                groupNameList.add(groupName);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("getThresholdGroupNames:  address/service: " + hostAddress + "/" + serviceName + ". Adding Group " + groupName));
            }
        }
        return groupNameList;
    }

    private Map<String, Set<ThresholdEntity>> getEntityMap(ThresholdGroup thresholdGroup, String resourceType) {
        Map<String, Set<ThresholdEntity>> entityMap = null;
        if ("node".equals(resourceType)) {
            entityMap = thresholdGroup.getNodeResourceType().getThresholdMap();
        } else if ("if".equals(resourceType)) {
            entityMap = thresholdGroup.getIfResourceType().getThresholdMap();
        } else {
            Map<String, ThresholdResourceType> typeMap = thresholdGroup.getGenericResourceTypeMap();
            if (typeMap == null) {
                this.log().error((Object)"getEntityMap: Generic Resource Type map was null (this shouldn't happen).");
                return null;
            }
            ThresholdResourceType thisResourceType = typeMap.get(resourceType);
            if (thisResourceType == null) {
                this.log().warn((Object)("getEntityMap: No thresholds configured for resource type " + resourceType + ". Not processing this collection."));
                return null;
            }
            entityMap = thisResourceType.getThresholdMap();
        }
        return entityMap;
    }

    public String toString() {
        return this.m_thresholdGroups.toString();
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

