/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.HashMap;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

public class ThresholdEvaluatorAbsoluteChange
implements ThresholdEvaluator {
    private static final String TYPE = "absoluteChange";

    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold) {
        return new ThresholdEvaluatorStateAbsoluteChange(threshold);
    }

    public boolean supportsType(String type) {
        return TYPE.equals(type);
    }

    public static class ThresholdEvaluatorStateAbsoluteChange
    extends AbstractThresholdEvaluatorState {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;
        private double m_change;
        private double m_lastSample = Double.NaN;
        private double m_previousTriggeringSample;

        public ThresholdEvaluatorStateAbsoluteChange(BaseThresholdDefConfigWrapper threshold) {
            Assert.notNull((Object)threshold, (String)"threshold argument cannot be null");
            this.setThresholdConfig(threshold);
        }

        public void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            Assert.isTrue((boolean)ThresholdEvaluatorAbsoluteChange.TYPE.equals(thresholdConfig.getType()), (String)("threshold for ds-name '" + thresholdConfig.getDatasourceExpression() + "' has type of '" + thresholdConfig.getType() + "', but this evaluator only supports thresholds with a 'type' value of '" + ThresholdEvaluatorAbsoluteChange.TYPE + "'"));
            Assert.isTrue((thresholdConfig.getValue() != Double.NaN ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is a number");
            Assert.isTrue((thresholdConfig.getValue() != Double.POSITIVE_INFINITY && thresholdConfig.getValue() != Double.NEGATIVE_INFINITY ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is not positive or negative infinity");
            Assert.isTrue((thresholdConfig.getValue() != 0.0 ? 1 : 0) != 0, (String)"threshold must not be 0 for absolute change");
            this.m_thresholdConfig = thresholdConfig;
            this.setChange(thresholdConfig.getValue());
        }

        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        public ThresholdEvaluatorState.Status evaluate(double dsValue) {
            if (this.getLastSample() != Double.NaN) {
                double threshold = this.getLastSample() + this.getChange();
                if (this.getChange() < 0.0) {
                    if (dsValue <= threshold) {
                        this.setPreviousTriggeringSample(this.getLastSample());
                        this.setLastSample(dsValue);
                        return ThresholdEvaluatorState.Status.TRIGGERED;
                    }
                } else if (dsValue >= threshold) {
                    this.setPreviousTriggeringSample(this.getLastSample());
                    this.setLastSample(dsValue);
                    return ThresholdEvaluatorState.Status.TRIGGERED;
                }
            }
            this.setLastSample(dsValue);
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        public Double getLastSample() {
            return this.m_lastSample;
        }

        public void setLastSample(double lastSample) {
            this.m_lastSample = lastSample;
        }

        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, CollectionResourceWrapper resource) {
            if (status == ThresholdEvaluatorState.Status.TRIGGERED) {
                String uei = this.getThresholdConfig().getTriggeredUEI();
                if (uei == null || "".equals(uei)) {
                    uei = "uei.opennms.org/threshold/absoluteChangeExceeded";
                }
                return this.createBasicEvent(uei, date, dsValue, resource);
            }
            return null;
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("previousValue", Double.toString(this.getPreviousTriggeringSample()));
            params.put("changeThreshold", Double.toString(this.getThresholdConfig().getValue()));
            return this.createBasicEvent(uei, date, dsValue, resource, params);
        }

        public double getPreviousTriggeringSample() {
            return this.m_previousTriggeringSample;
        }

        public void setPreviousTriggeringSample(double previousTriggeringSample) {
            this.m_previousTriggeringSample = previousTriggeringSample;
        }

        public double getChange() {
            return this.m_change;
        }

        public void setChange(double change) {
            this.m_change = change;
        }

        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateAbsoluteChange(this.m_thresholdConfig);
        }

        public boolean isTriggered() {
            return false;
        }

        public void clearState() {
        }
    }
}

