/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorThresholdingSet
extends ThresholdingSet {
    public CollectorThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository, long interval) {
        super(nodeId, hostAddress, serviceName, repository, interval);
    }

    public boolean hasThresholds(CollectionAttribute attribute) {
        CollectionResource resource = attribute.getResource();
        return this.hasThresholds(resource.getResourceTypeName(), attribute.getName());
    }

    public List<Event> applyThresholds(CollectionResource resource, Map<String, CollectionAttribute> attributesMap) {
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(this.m_interval, this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, resource, attributesMap);
        return this.applyThresholds(resourceWrapper, attributesMap);
    }

    @Override
    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        if (resource.isAnInterfaceResource() && !resource.isValidInterfaceResource()) {
            this.log().info((Object)("passedThresholdFilters: Could not get data interface information for '" + resource.getIfLabel() + "' or this interface has an invalid ifIndex.  Not evaluating threshold."));
            return false;
        }
        return super.passedThresholdFilters(resource, thresholdEntity);
    }
}

