/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.config.DataSourceFactory;

final class SyslogdIPMgr {
    private static final String IP_LOAD_SQL = "SELECT ipAddr, nodeid FROM ipInterface";
    private static Map<String, Long> m_knownips = new HashMap<String, Long>();

    SyslogdIPMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void dataSourceSync() throws SQLException {
        Connection c = null;
        try {
            c = DataSourceFactory.getInstance().getConnection();
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(IP_LOAD_SQL);
            if (rs != null) {
                m_knownips.clear();
                while (rs.next()) {
                    String ipstr = rs.getString(1);
                    long ipnodeid = rs.getLong(2);
                    m_knownips.put(ipstr, ipnodeid);
                }
                rs.close();
            }
            s.close();
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    static synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return SyslogdIPMgr.longValue(m_knownips.get(addr));
    }

    static synchronized long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        return SyslogdIPMgr.longValue(m_knownips.put(addr, nodeid));
    }

    static long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return SyslogdIPMgr.longValue(m_knownips.remove(addr));
    }

    private static long longValue(Long result) {
        return result == null ? -1L : result;
    }
}

