/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.syslogd.BroadcastEventProcessor;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.SyslogHandler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

final class SyslogProcessor
implements Runnable {
    private BroadcastEventProcessor m_eventReader;
    private Thread m_context = null;
    private volatile boolean m_stop = false;
    private boolean m_NewSuspectOnMessage;
    private String m_logPrefix;
    private String m_localAddr;

    public static void setSyslogConfig(SyslogdConfig syslogdConfig) {
        SyslogdConfig m_syslogdConfig = syslogdConfig;
    }

    SyslogProcessor(boolean newSuspectOnMessage, String forwardingRegexp, int matchingGroupHost, int matchingGroupMessage, UeiList ueiList, HideMessage hideMessages) {
        this.m_NewSuspectOnMessage = newSuspectOnMessage;
        this.m_logPrefix = "OpenNMS.Syslogd";
        try {
            this.m_localAddr = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            Logger log = ThreadCategory.getInstance(this.getClass());
            this.m_localAddr = "localhost";
            log.error((Object)"Error looking up local hostname; using 'localhost'", (Throwable)uhE);
        }
    }

    boolean isAlive() {
        return this.m_context != null && this.m_context.isAlive();
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Logger log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping and joining thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            log.debug((Object)"Thread context stopped and joined");
        }
    }

    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Logger log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isEnabledFor((Priority)Level.TRACE);
        if (this.m_stop) {
            if (isTracing) {
                log.log((Priority)Level.TRACE, (Object)"Stop flag set before thread started, exiting");
            }
            return;
        }
        if (isTracing) {
            log.debug((Object)"Thread context started");
        }
        while (!this.m_stop) {
            ConvertToEvent o = null;
            o = SyslogHandler.queueManager.getFromQueue();
            if (o == null) continue;
            try {
                if (isTracing) {
                    Parm[] parms;
                    log.log((Priority)Level.TRACE, (Object)("Processing a syslog to event dispatch" + o.toString()));
                    String uuid = o.getEvent().getUuid();
                    log.log((Priority)Level.TRACE, (Object)"Event {");
                    log.log((Priority)Level.TRACE, (Object)("  uuid  = " + (uuid != null && uuid.length() > 0 ? uuid : "<not-set>")));
                    log.log((Priority)Level.TRACE, (Object)("  uei   = " + o.getEvent().getUei()));
                    log.log((Priority)Level.TRACE, (Object)("  src   = " + o.getEvent().getSource()));
                    log.log((Priority)Level.TRACE, (Object)("  iface = " + o.getEvent().getInterface()));
                    log.log((Priority)Level.TRACE, (Object)("  time  = " + o.getEvent().getTime()));
                    log.log((Priority)Level.TRACE, (Object)("  Msg   = " + o.getEvent().getLogmsg().getContent()));
                    log.log((Priority)Level.TRACE, (Object)("  Dst   = " + o.getEvent().getLogmsg().getDest()));
                    Parm[] parmArray = parms = o.getEvent().getParms() == null ? null : o.getEvent().getParms().getParm();
                    if (parms != null) {
                        log.log((Priority)Level.TRACE, (Object)"  parms {");
                        for (Parm parm : parms) {
                            if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                            log.log((Priority)Level.TRACE, (Object)("    (" + parm.getParmName().trim() + ", " + parm.getValue().getContent().trim() + ")"));
                        }
                        log.log((Priority)Level.TRACE, (Object)"  }");
                    }
                    log.log((Priority)Level.TRACE, (Object)"}");
                }
                EventIpcManagerFactory.getIpcManager().sendNow(o.getEvent());
                if (!this.m_NewSuspectOnMessage || o.getEvent().hasNodeid()) continue;
                if (isTracing) {
                    log.log((Priority)Level.TRACE, (Object)("Syslogd: Found a new suspect " + o.getEvent().getInterface()));
                }
                this.sendNewSuspectEvent(o.getEvent().getInterface());
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error processing SyslogMessage - Could not send", t);
            }
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private void sendNewSuspectEvent(String trapInterface) {
        Event event = new Event();
        event.setSource("syslogd");
        event.setUei("uei.opennms.org/internal/discovery/newSuspect");
        event.setHost(this.m_localAddr);
        event.setInterface(trapInterface);
        event.setTime(EventConstants.formatToString((Date)new Date()));
        EventIpcManagerFactory.getIpcManager().sendNow(event);
    }
}

