/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.text.ParseException;
import java.util.Hashtable;

public class SyslogDefs {
    public static final String RCS_ID = "$Id: SyslogDefs-OLD.java,v 1.1.1.1 1998/02/22 05:47:54 time Exp $";
    public static final String RCS_REV = "$Revision: 1.1.1.1 $";
    public static final String RCS_NAME = "$Name:  $";
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_ALL = 8;
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 1;
    public static final int LOG_MAIL = 2;
    public static final int LOG_DAEMON = 3;
    public static final int LOG_AUTH = 4;
    public static final int LOG_SYSLOG = 5;
    public static final int LOG_LPR = 6;
    public static final int LOG_NEWS = 7;
    public static final int LOG_UUCP = 8;
    public static final int LOG_CRON = 9;
    public static final int LOG_LOCAL0 = 16;
    public static final int LOG_LOCAL1 = 17;
    public static final int LOG_LOCAL2 = 18;
    public static final int LOG_LOCAL3 = 19;
    public static final int LOG_LOCAL4 = 20;
    public static final int LOG_LOCAL5 = 21;
    public static final int LOG_LOCAL6 = 22;
    public static final int LOG_LOCAL7 = 23;
    public static final int LOG_NFACILITIES = 24;
    public static final int LOG_PRIMASK = 7;
    public static final int LOG_FACMASK = 1016;
    public static final int INTERNAL_NOPRI = 16;
    public static final int LOG_PID = 1;
    public static final int LOG_CONS = 2;
    public static final int LOG_ODELAY = 4;
    public static final int LOG_NDELAY = 8;
    public static final int LOG_NOWAIT = 16;
    public static final int LOG_PERROR = 32;
    public static final int DEFAULT_PORT = 514;
    private static Hashtable<String, Integer> facHash = new Hashtable(20);
    private static Hashtable<String, Integer> priHash;

    public static int extractFacility(int code) {
        return (code & 0x3F8) >> 3;
    }

    public static int extractPriority(int code) {
        return code & 7;
    }

    public static int computeCode(int facility, int priority) {
        return facility << 3 | priority;
    }

    public static String getPriorityName(int level) {
        switch (level) {
            case 0: {
                return "Emergency";
            }
            case 1: {
                return "Alert";
            }
            case 2: {
                return "Critical";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Warning";
            }
            case 5: {
                return "Notice";
            }
            case 6: {
                return "Info";
            }
            case 7: {
                return "Debug";
            }
        }
        return "unknown level='" + level + "'";
    }

    public static String getFacilityName(int facility) {
        switch (facility) {
            case 0: {
                return "kernel";
            }
            case 1: {
                return "user";
            }
            case 2: {
                return "mail";
            }
            case 3: {
                return "daemon";
            }
            case 4: {
                return "auth";
            }
            case 5: {
                return "syslog";
            }
            case 6: {
                return "lpr";
            }
            case 7: {
                return "news";
            }
            case 8: {
                return "uucp";
            }
            case 9: {
                return "cron";
            }
            case 16: {
                return "local0";
            }
            case 17: {
                return "local1";
            }
            case 18: {
                return "local2";
            }
            case 19: {
                return "local3";
            }
            case 20: {
                return "local4";
            }
            case 21: {
                return "local5";
            }
            case 22: {
                return "local6";
            }
            case 23: {
                return "local7";
            }
        }
        return "unknown facility='" + facility + "'";
    }

    public static String getPriority(String priority) throws ParseException {
        String priKey = priority.toUpperCase();
        String result = priHash.get(priKey).toString();
        if (result == null) {
            throw new ParseException("unknown priority '" + priority + "'", 0);
        }
        return result;
    }

    public static int getFacility(String facility) throws ParseException {
        String facKey = facility.toUpperCase();
        Integer result = facHash.get(facKey);
        if (result == null) {
            throw new ParseException("unknown facility '" + facility + "'", 0);
        }
        return result;
    }

    static {
        facHash.put("KERN", 0);
        facHash.put("KERNEL", 0);
        facHash.put("USER", 1);
        facHash.put("MAIL", 2);
        facHash.put("DAEMON", new Integer(3));
        facHash.put("AUTH", new Integer(4));
        facHash.put("SYSLOG", new Integer(5));
        facHash.put("LPR", new Integer(6));
        facHash.put("NEWS", new Integer(7));
        facHash.put("UUCP", new Integer(8));
        facHash.put("CRON", new Integer(9));
        facHash.put("LOCAL0", new Integer(16));
        facHash.put("LOCAL1", new Integer(17));
        facHash.put("LOCAL2", new Integer(18));
        facHash.put("LOCAL3", new Integer(19));
        facHash.put("LOCAL4", new Integer(20));
        facHash.put("LOCAL5", new Integer(21));
        facHash.put("LOCAL6", new Integer(22));
        facHash.put("LOCAL7", new Integer(23));
        priHash = new Hashtable(20);
        priHash.put("EMERG", new Integer(0));
        priHash.put("EMERGENCY", new Integer(0));
        priHash.put("LOG_EMERG", new Integer(0));
        priHash.put("ALERT", new Integer(1));
        priHash.put("LOG_ALERT", new Integer(1));
        priHash.put("CRIT", new Integer(2));
        priHash.put("CRITICAL", new Integer(2));
        priHash.put("LOG_CRIT", new Integer(2));
        priHash.put("ERR", new Integer(3));
        priHash.put("ERROR", new Integer(3));
        priHash.put("LOG_ERR", new Integer(3));
        priHash.put("WARNING", new Integer(4));
        priHash.put("LOG_WARNING", new Integer(4));
        priHash.put("NOTICE", new Integer(5));
        priHash.put("LOG_NOTICE", new Integer(5));
        priHash.put("INFO", new Integer(6));
        priHash.put("LOG_INFO", new Integer(6));
        priHash.put("DEBUG", new Integer(7));
        priHash.put("LOG_DEBUG", new Integer(7));
    }
}

