/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPollInterfaceMonitor;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPoller;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterfaceConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollableSnmpInterface
implements ReadyRunnable {
    private boolean firstrun = true;
    private Map<Integer, SnmpPoller.AlarmStatus> m_alarmStatus;
    private volatile Schedule m_schedule;
    private HashMap<Integer, OnmsSnmpInterface> m_snmpinterfaces;
    private PollableSnmpInterfaceConfig m_snmppollableconfig;
    private PollableInterface m_parent;
    private String m_name;
    private String m_criteria;
    private SnmpAgentConfig m_agentConfig;
    private int maxInterfacePerPdu = 0;

    public Collection<OnmsSnmpInterface> getSnmpinterfaces() {
        return this.m_snmpinterfaces.values();
    }

    public void setSnmpinterfaces(List<OnmsSnmpInterface> snmpinterfaces) {
        if (snmpinterfaces != null && !snmpinterfaces.isEmpty()) {
            for (OnmsSnmpInterface value : snmpinterfaces) {
                this.m_snmpinterfaces.put(value.getIfIndex(), value);
            }
        }
    }

    public PollableSnmpInterface(PollableInterface parent) {
        this.m_parent = parent;
        this.m_snmpinterfaces = new HashMap();
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    public PollableSnmpInterfaceConfig getSnmppollableconfig() {
        return this.m_snmppollableconfig;
    }

    public void setSnmppollableconfig(PollableSnmpInterfaceConfig snmppollableconfig) {
        this.m_snmppollableconfig = snmppollableconfig;
    }

    public PollableInterface getParent() {
        return this.m_parent;
    }

    public PollContext getContext() {
        return this.getParent().getContext();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void run() {
        if (this.getParent().polling()) {
            this.log().warn((Object)("run: polling snmp interfaces on package/interface " + this.getParent().getPackageName() + "/" + this.getName() + "on primary address: " + this.getParent().getIpaddress()));
            if (this.m_snmpinterfaces == null || this.m_snmpinterfaces.isEmpty()) {
                this.log().info((Object)"No Interface found. Doing nothing");
            } else {
                this.log().info((Object)(this.m_snmpinterfaces.size() + " Interfaces found. Getting Statutes...."));
                SnmpPollInterfaceMonitor pollMonitor = new SnmpPollInterfaceMonitor();
                int maxiface = this.getMaxInterfacePerPdu();
                if (maxiface == 0) {
                    maxiface = this.m_snmpinterfaces.size();
                }
                this.log().debug((Object)("Max Interface Per Pdu is: " + maxiface));
                List<SnmpMinimalPollInterface> mifaces = this.getSnmpMinimalPollInterface();
                int start = 0;
                while (start + maxiface < this.m_snmpinterfaces.size()) {
                    this.doPoll(pollMonitor, mifaces.subList(start, start + maxiface));
                    start += maxiface;
                }
                this.doPoll(pollMonitor, mifaces.subList(start, this.m_snmpinterfaces.size()));
                this.firstrun = false;
            }
        } else {
            this.log().info((Object)("not polling: " + this.getParent().getIpaddress()));
        }
    }

    private void doPoll(SnmpPollInterfaceMonitor pollMonitor, List<SnmpMinimalPollInterface> mifaces) {
        this.log().info((Object)("doPoll: input interfaces number: " + mifaces.size()));
        mifaces = pollMonitor.poll(this.getAgentConfig(), mifaces);
        if (mifaces != null) {
            this.log().info((Object)("doPoll: PollerMonitor return interfaces number: " + mifaces.size()));
            for (SnmpMinimalPollInterface miface : mifaces) {
                this.log().debug((Object)("Working on interface with ifindex: " + miface.getIfindex()));
                this.log().debug((Object)("Interface PollStatus is " + miface.getStatus().getStatusName()));
                if (miface.getStatus().isUp()) {
                    OnmsSnmpInterface iface = this.m_snmpinterfaces.get(new Integer(miface.getIfindex()));
                    boolean changed = false;
                    this.log().debug((Object)("Previuos status Admin/Oper: " + iface.getIfAdminStatus() + "/" + iface.getIfOperStatus()));
                    this.log().debug((Object)("Current status Admin/Oper: " + miface.getAdminstatus() + "/" + miface.getOperstatus()));
                    if (this.firstrun) {
                        if (miface.getAdminstatus() == 1 && miface.getOperstatus() == 2 && !this.hasOperDownAlarm(miface.getIfindex())) {
                            this.sendOperDownEvent(iface);
                        }
                        if (miface.getAdminstatus() == 1 && miface.getOperstatus() == 1 && this.hasOperDownAlarm(miface.getIfindex())) {
                            this.sendOperUpEvent(iface);
                        }
                        if (!this.suppressAdminDownEvent() && miface.getAdminstatus() == 2 && !this.hasAdminDownAlarm(miface.getIfindex())) {
                            this.sendAdminDownEvent(iface);
                        }
                        if (!this.suppressAdminDownEvent() && miface.getAdminstatus() == 1 && this.hasAdminDownAlarm(miface.getIfindex())) {
                            this.sendAdminUpEvent(iface);
                        }
                    }
                    if (iface.getIfAdminStatus().intValue() != miface.getAdminstatus()) {
                        changed = true;
                        iface.setIfAdminStatus(new Integer(miface.getAdminstatus()));
                        if (!this.firstrun && !this.suppressAdminDownEvent()) {
                            if (miface.getAdminstatus() == 2) {
                                this.sendAdminDownEvent(iface);
                            }
                            if (miface.getAdminstatus() == 1) {
                                this.sendAdminUpEvent(iface);
                            }
                        }
                    }
                    if (iface.getIfOperStatus().intValue() != miface.getOperstatus()) {
                        changed = true;
                        iface.setIfOperStatus(new Integer(miface.getOperstatus()));
                        if (!this.firstrun && miface.getAdminstatus() == 1) {
                            if (miface.getOperstatus() == 2) {
                                this.sendOperDownEvent(iface);
                            }
                            if (miface.getOperstatus() == 1) {
                                this.sendOperUpEvent(iface);
                            }
                        }
                    }
                    this.log().debug((Object)("Interface changed = " + changed));
                    if (!changed) continue;
                    this.update(iface);
                    continue;
                }
                this.log().warn((Object)("run: " + this.getContext().getServiceName() + " not available, doing nothing....."));
            }
        } else {
            this.log().error((Object)"the monitor return null object");
        }
    }

    private boolean hasOperDownAlarm(int ifindex) {
        if (this.m_alarmStatus.containsKey(ifindex)) {
            return this.m_alarmStatus.get(ifindex).hasOperStatusDownAlarm();
        }
        return false;
    }

    private boolean hasAdminDownAlarm(int ifindex) {
        if (this.m_alarmStatus.containsKey(ifindex)) {
            return this.m_alarmStatus.get(ifindex).hasAdminStatusDownAlarm();
        }
        return false;
    }

    private void update(OnmsSnmpInterface iface) {
        this.getContext().update(iface);
    }

    private void sendAdminUpEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceAdminUp", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getDate(), iface));
    }

    private void sendAdminDownEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceAdminDown", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getDate(), iface));
    }

    private void sendOperUpEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceOperUp", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getDate(), iface));
    }

    private void sendOperDownEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceOperDown", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getDate(), iface));
    }

    private Date getDate() {
        return new Date();
    }

    private SnmpMinimalPollInterface getMinimalFromOnmsSnmpInterface(OnmsSnmpInterface iface) {
        int adminStatus = 1;
        int operStatus = 1;
        if (iface.getIfAdminStatus() != null) {
            adminStatus = iface.getIfAdminStatus();
        } else {
            iface.setIfAdminStatus(Integer.valueOf(0));
        }
        if (iface.getIfOperStatus() != null) {
            operStatus = iface.getIfOperStatus();
        } else {
            iface.setIfOperStatus(Integer.valueOf(0));
        }
        return new SnmpMinimalPollInterface(iface.getIfIndex(), adminStatus, operStatus);
    }

    private List<SnmpMinimalPollInterface> getSnmpMinimalPollInterface() {
        ArrayList<SnmpMinimalPollInterface> mifaces = new ArrayList<SnmpMinimalPollInterface>();
        Iterator<OnmsSnmpInterface> ite = this.getSnmpinterfaces().iterator();
        while (ite.hasNext()) {
            mifaces.add(this.getMinimalFromOnmsSnmpInterface(ite.next()));
        }
        return mifaces;
    }

    public void schedule() {
        if (this.m_schedule == null) {
            throw new IllegalStateException("Cannot schedule a service whose schedule is set to null");
        }
        this.m_schedule.schedule();
    }

    protected void delete() {
        this.m_schedule.unschedule();
    }

    private Category log() {
        return ThreadCategory.getInstance(PollableService.class);
    }

    public SnmpAgentConfig getAgentConfig() {
        return this.m_agentConfig;
    }

    public void setAgentConfig(SnmpAgentConfig config) {
        this.m_agentConfig = config;
    }

    public String getCriteria() {
        return this.m_criteria;
    }

    public void setCriteria(String m_criteria) {
        this.m_criteria = m_criteria;
    }

    public boolean suppressAdminDownEvent() {
        return this.getContext().suppressAdminDownEvent();
    }

    public int getMaxInterfacePerPdu() {
        return this.maxInterfacePerPdu;
    }

    public void setMaxInterfacePerPdu(int maxInterfacePerPdu) {
        this.maxInterfacePerPdu = maxInterfacePerPdu;
    }

    public Map<Integer, SnmpPoller.AlarmStatus> getAlarmStatus() {
        return this.m_alarmStatus;
    }

    public void setAlarmStatus(Map<Integer, SnmpPoller.AlarmStatus> alarmStatusMap) {
        this.m_alarmStatus = alarmStatusMap;
    }

    public class SnmpMinimalPollInterface {
        static final int IF_UP = 1;
        static final int IF_DOWN = 2;
        static final int IF_UNKNOWN = 0;
        private final String[] s_statusNames = new String[]{"Unknown", "InterfaceUp", "InterfaceDown"};
        int ifindex;
        int adminstatus;
        int operstatus;
        PollStatus m_status;

        public SnmpMinimalPollInterface(int ifindex, int adminstatus, int operstatus) {
            this.ifindex = ifindex;
            this.adminstatus = adminstatus;
            this.operstatus = operstatus;
            this.m_status = PollStatus.unknown();
        }

        public String decodeStatus(int status) {
            if (status >= 0 && status <= 2) {
                return this.s_statusNames[status];
            }
            return this.s_statusNames[0];
        }

        public int getIfindex() {
            return this.ifindex;
        }

        public void setIfindex(int ifindex) {
            this.ifindex = ifindex;
        }

        public int getAdminstatus() {
            return this.adminstatus;
        }

        public void setAdminstatus(int adminstatus) {
            this.adminstatus = adminstatus > 2 ? 0 : adminstatus;
        }

        public int getOperstatus() {
            return this.operstatus;
        }

        public void setOperstatus(int operstatus) {
            if (operstatus > 2) {
                this.operstatus = 0;
            }
            this.operstatus = operstatus;
        }

        public PollStatus getStatus() {
            return this.m_status;
        }

        public void setStatus(PollStatus status) {
            this.m_status = status;
        }
    }
}

