/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;

public class PollableNetwork {
    private final Map<String, PollableInterface> m_members = new HashMap<String, PollableInterface>();
    private final Map<Integer, String> m_node = new HashMap<Integer, String>();
    private PollContext m_context;

    public PollableNetwork(PollContext context) {
        this.m_context = context;
    }

    public PollableInterface create(int nodeid, String ipaddress, String packageName) {
        PollableInterface nodeGroup = new PollableInterface(this);
        nodeGroup.setNodeid(nodeid);
        nodeGroup.setIpaddress(ipaddress);
        nodeGroup.setPackageName(packageName);
        nodeGroup.initialize();
        this.m_members.put(nodeGroup.getIpaddress(), nodeGroup);
        this.m_node.put(new Integer(nodeGroup.getNodeid()), nodeGroup.getIpaddress());
        return nodeGroup;
    }

    public void deleteAll() {
        Iterator<PollableInterface> ite = this.m_members.values().iterator();
        while (ite.hasNext()) {
            ite.next().delete();
        }
        this.m_members.clear();
        this.m_node.clear();
    }

    public void delete(String ipaddress) {
        PollableInterface pi = this.getInterface(ipaddress);
        if (pi != null) {
            this.m_members.remove(ipaddress);
            this.m_node.remove(new Integer(pi.getNodeid()));
            pi.delete();
        }
    }

    public void refresh(int nodeid) {
        String ipaddress = this.getIp(nodeid);
        if (ipaddress != null) {
            this.getInterface(ipaddress).refresh();
        }
    }

    public void suspend(String ipaddress) {
        PollableInterface pi = this.getInterface(ipaddress);
        if (pi != null) {
            pi.suspend();
        }
    }

    public void activate(String ipaddress) {
        PollableInterface pi = this.getInterface(ipaddress);
        if (pi != null) {
            pi.activate();
        }
    }

    public String getIp(int nodeid) {
        return this.m_node.get(new Integer(nodeid));
    }

    private PollableInterface getInterface(String ipaddress) {
        if (this.m_members.containsKey(ipaddress)) {
            return this.m_members.get(ipaddress);
        }
        return null;
    }

    public int getNodeid(String ipaddress) {
        for (PollableInterface pi : this.m_members.values()) {
            if (!pi.getIpaddress().equals(ipaddress)) continue;
            return pi.getNodeid();
        }
        return 0;
    }

    public PollContext getContext() {
        return this.m_context;
    }

    public void setContext(PollContext context) {
        this.m_context = context;
    }
}

