/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.snmpinterfacepoller.Interface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableNetwork;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollableInterface {
    private int m_nodeid;
    private String m_ipaddress;
    private PollableNetwork m_parent;
    private HashMap<String, PollableSnmpInterface> m_pollablesnmpinterface;
    private String m_packageName;
    private boolean polling = true;

    protected void initialize() {
        try {
            SnmpPeerFactory.init();
        }
        catch (UnknownHostException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        catch (MarshalException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    public int getNodeid() {
        return this.m_nodeid;
    }

    public void setNodeid(int nodeid) {
        this.m_nodeid = nodeid;
    }

    public String getIpaddress() {
        return this.m_ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.m_ipaddress = ipaddress;
    }

    public PollableInterface(PollableNetwork parent) {
        this.m_parent = parent;
        this.m_pollablesnmpinterface = new HashMap();
    }

    public PollableSnmpInterface createPollableSnmpInterface(Interface pkgIface) {
        PollableSnmpInterface iface = new PollableSnmpInterface(this);
        iface.setName(pkgIface.getName());
        iface.setCriteria(pkgIface.getCriteria());
        InetAddress ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(this.getIpaddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (pkgIface.hasPort()) {
            agentConfig.setPort(pkgIface.getPort());
        }
        if (pkgIface.hasTimeout()) {
            agentConfig.setTimeout(pkgIface.getTimeout());
        }
        if (pkgIface.hasRetry()) {
            agentConfig.setRetries(pkgIface.getRetry());
        }
        if (pkgIface.hasMaxVarsPerPdu()) {
            agentConfig.setMaxVarsPerPdu(pkgIface.getMaxVarsPerPdu());
        }
        iface.setAgentConfig(agentConfig);
        if (pkgIface.hasMaxInterfacePerPdu()) {
            iface.setMaxInterfacePerPdu(pkgIface.getMaxInterfacePerPdu());
        }
        this.m_pollablesnmpinterface.put(pkgIface.getName(), iface);
        return iface;
    }

    protected void refresh() {
        for (PollableSnmpInterface node : this.getSnmpinterfacepollableNodes().values()) {
            PollableSnmpInterface pollableSnmpInterface = this.getContext().refresh(node);
        }
    }

    protected void suspend() {
        this.polling = false;
    }

    protected void activate() {
        this.polling = true;
    }

    public HashMap<String, PollableSnmpInterface> getSnmpinterfacepollableNodes() {
        return this.m_pollablesnmpinterface;
    }

    public boolean polling() {
        return this.polling;
    }

    protected void delete() {
        Iterator<PollableSnmpInterface> ite = this.getSnmpinterfacepollableNodes().values().iterator();
        while (ite.hasNext()) {
            ite.next().delete();
        }
    }

    public PollableNetwork getParent() {
        return this.m_parent;
    }

    public void setParent(PollableNetwork parent) {
        this.m_parent = parent;
    }

    public PollContext getContext() {
        return this.getParent().getContext();
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }
}

