/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.config.snmpinterfacepoller.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.snmpinterfacepoller.QueryManager;
import org.opennms.netmgt.snmpinterfacepoller.SnmpInterfacePollerEventProcessor;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableNetwork;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterfaceConfig;
import org.opennms.netmgt.utils.Querier;

public class SnmpPoller
extends AbstractServiceDaemon {
    private static final SnmpPoller m_singleton = new SnmpPoller();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private SnmpInterfacePollerEventProcessor m_eventProcessor;
    private QueryManager m_queryManager;
    private SnmpInterfacePollerConfig m_pollerConfig;
    private EventIpcManager m_eventMgr;
    private DataSource m_dataSource;
    private PollableNetwork m_network;
    private static Map<Integer, Map<Integer, AlarmStatus>> m_nodeAlarmStatusMap;

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork pollableNetwork) {
        this.m_network = pollableNetwork;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public SnmpInterfacePollerEventProcessor getEventProcessor() {
        return this.m_eventProcessor;
    }

    public void setEventProcessor(SnmpInterfacePollerEventProcessor eventProcessor) {
        this.m_eventProcessor = eventProcessor;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public SnmpInterfacePollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(SnmpInterfacePollerConfig snmpinterfacepollerConfig) {
        this.m_pollerConfig = snmpinterfacepollerConfig;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    protected void onStart() {
        try {
            this.log().debug((Object)"start: Starting Snmp Interface Poller scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            this.getScheduler().stop();
        }
        if (this.getEventProcessor() != null) {
            this.getEventProcessor().close();
        }
        this.setScheduler(null);
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public static SnmpPoller getInstance() {
        return m_singleton;
    }

    public SnmpPoller() {
        super("OpenNMS.SnmpPoller");
    }

    protected void onInit() {
        try {
            this.log().debug((Object)"start: select snmppoll alarms from alarm table");
            this.selectExistingSnmpPollAlarms();
        }
        catch (Exception sqlE) {
            this.log().error((Object)"start: Failed to delete existing snmppoll alarms", (Throwable)sqlE);
        }
        this.createScheduler();
        try {
            this.log().debug((Object)"start: Scheduling existing snmp interfaces polling");
            this.scheduleExistingSnmpInterface();
        }
        catch (Exception sqlE) {
            this.log().error((Object)"start: Failed to schedule existing interfaces", (Throwable)sqlE);
        }
        try {
            this.log().debug((Object)"start: Creating event broadcast event processor");
            this.setEventProcessor(new SnmpInterfacePollerEventProcessor(this));
        }
        catch (Throwable t) {
            this.log().fatal((Object)"start: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_initialized = true;
    }

    protected void deleteSnmpInterface(int nodeid) {
        this.getNetwork().delete(this.getNetwork().getIp(nodeid));
    }

    protected void selectExistingSnmpPollAlarms() {
        m_nodeAlarmStatusMap = new HashMap<Integer, Map<Integer, AlarmStatus>>();
        String sql = "select nodeid, ifindex, eventuei from alarms where eventuei like 'uei.opennms.org/nodes/snmp/interface%'";
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                SnmpPoller.this.setAlarmStatus(rs.getInt("nodeid"), rs.getInt("ifindex"), rs.getString("eventuei"));
            }
        };
        querier.execute();
    }

    protected void setAlarmStatus(int nodeid, int ifindex, String uei) {
        Map<Object, Object> alarmStatusMap = new HashMap();
        AlarmStatus alarmStatus = new AlarmStatus();
        if (m_nodeAlarmStatusMap.containsKey(nodeid) && (alarmStatusMap = m_nodeAlarmStatusMap.get(nodeid)).containsKey(ifindex)) {
            alarmStatus = (AlarmStatus)alarmStatusMap.get(ifindex);
        }
        if (uei.equals("uei.opennms.org/nodes/snmp/interfaceOperDown")) {
            alarmStatus.setHasOperStatusDownAlarm(true);
        }
        if (uei.equals("uei.opennms.org/nodes/snmp/interfaceAdminDown")) {
            alarmStatus.setHasAdminStatusDownAlarm(true);
        }
        alarmStatusMap.put(ifindex, alarmStatus);
        m_nodeAlarmStatusMap.put(nodeid, alarmStatusMap);
    }

    protected void scheduleNewSnmpInterface(String ipaddr) {
        String sql = "SELECT nodeid, ipaddr from ipinterface where issnmpprimary = 'P' and ismanaged = 'M' and ipaddr = '" + ipaddr + "'";
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                SnmpPoller.this.schedulePollableInterface(rs.getInt("nodeid"), rs.getString("ipaddr"));
            }
        };
        querier.execute();
    }

    protected void scheduleExistingSnmpInterface() {
        String sql = "SELECT nodeid, ipaddr from ipinterface where issnmpprimary = 'P' and ismanaged='M'";
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                SnmpPoller.this.schedulePollableInterface(rs.getInt("nodeid"), rs.getString("ipaddr"));
            }
        };
        querier.execute();
    }

    protected void schedulePollableInterface(int nodeid, String ipaddress) {
        Package pkg;
        if (ipaddress != null && !ipaddress.equals("0.0.0.0") && (pkg = this.getPollerConfig().getPackageForAddress(ipaddress)) != null) {
            this.scheduleSnmpCollection(this.getNetwork().create(nodeid, ipaddress, pkg.getName()), pkg);
        }
    }

    private void scheduleSnmpCollection(PollableInterface nodeGroup, Package pkg) {
        for (int j = 0; j < pkg.getInterfaceCount(); ++j) {
            this.log().debug((Object)("found package interface with name: " + pkg.getInterface(j).getName()));
            if (pkg.getInterface(j).getStatus().equals("on")) {
                this.log().debug((Object)("package interface: criteria: " + pkg.getInterface(j).getCriteria()));
                this.log().debug((Object)("package interface: interval: " + pkg.getInterface(j).getInterval()));
                PollableSnmpInterface node = nodeGroup.createPollableSnmpInterface(pkg.getInterface(j));
                this.scheduleSnmpCollection(node, pkg.getInterface(j).getCriteria(), pkg.getInterface(j).getInterval());
                continue;
            }
            this.log().debug((Object)("package interface: status: " + pkg.getInterface(j).getStatus()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSnmpCollection(PollableSnmpInterface node, String criteria, long interval) {
        criteria = criteria + " and nodeid = " + node.getParent().getNodeid();
        List<OnmsSnmpInterface> snmpinterfacelist = this.getQueryManager().getSnmpInterfaces(criteria);
        if (snmpinterfacelist != null && snmpinterfacelist.size() > 0) {
            node.setSnmpinterfaces(snmpinterfacelist);
            if (m_nodeAlarmStatusMap.containsKey(node.getParent().getNodeid())) {
                node.setAlarmStatus(m_nodeAlarmStatusMap.get(node.getParent().getNodeid()));
            } else {
                node.setAlarmStatus(new HashMap<Integer, AlarmStatus>());
            }
            PollableSnmpInterfaceConfig nodeconfig = new PollableSnmpInterfaceConfig(this.getScheduler(), interval);
            node.setSnmppollableconfig(nodeconfig);
            PollableSnmpInterface pollableSnmpInterface = node;
            synchronized (pollableSnmpInterface) {
                if (node.getSchedule() == null) {
                    this.log().debug((Object)("Scheduling node: " + node.getParent().getIpaddress()));
                    Schedule schedule = new Schedule(node, nodeconfig, this.getScheduler());
                    node.setSchedule(schedule);
                }
            }
            node.schedule();
        } else {
            this.log().info((Object)("no interface found for node/criteria:" + node.getParent().getNodeid() + "/" + criteria));
        }
    }

    private void createScheduler() {
        try {
            this.log().debug((Object)"init: Creating Snmp Interface Poller scheduler");
            this.setScheduler(new LegacyScheduler("Snmpinterfacepoller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)"init: Failed to create snmp interface poller scheduler", (Throwable)e);
            throw e;
        }
    }

    public final class AlarmStatus {
        boolean _hasAdminStatusDownAlarm = false;
        boolean _hasOperStatusDownAlarm = false;

        public boolean hasAdminStatusDownAlarm() {
            return this._hasAdminStatusDownAlarm;
        }

        public void setHasAdminStatusDownAlarm(boolean adminStatusDownAlarm) {
            this._hasAdminStatusDownAlarm = adminStatusDownAlarm;
        }

        public boolean hasOperStatusDownAlarm() {
            return this._hasOperStatusDownAlarm;
        }

        public void setHasOperStatusDownAlarm(boolean operStatusDownAlarm) {
            this._hasOperStatusDownAlarm = operStatusDownAlarm;
        }
    }
}

