/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public class SnmpPollInterfaceMonitor {
    private static final String IF_ADMIN_STATUS_OID = ".1.3.6.1.2.1.2.2.1.7.";
    private static final String IF_OPER_STATUS_OID = ".1.3.6.1.2.1.2.2.1.8.";

    public List<PollableSnmpInterface.SnmpMinimalPollInterface> poll(SnmpAgentConfig agentConfig, List<PollableSnmpInterface.SnmpMinimalPollInterface> mifaces) {
        if (mifaces == null) {
            this.log().error((Object)"Null Interfaces passed to Monitor, exiting");
            return null;
        }
        this.log().debug((Object)("Got " + mifaces.size() + " interfaces to poll"));
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available");
        }
        SnmpObjId[] oids = new SnmpObjId[2 * mifaces.size()];
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            miface.setStatus(PollStatus.unavailable());
            mifaces.set(i, miface);
            oids[i] = SnmpObjId.get((String)(IF_ADMIN_STATUS_OID + miface.getIfindex()));
            this.log().debug((Object)("Adding oid: " + oids[i] + " at position " + i));
            oids[i + mifaces.size()] = SnmpObjId.get((String)(IF_OPER_STATUS_OID + miface.getIfindex()));
            this.log().debug((Object)("Adding oid: " + oids[i + mifaces.size()] + " at position " + (i + mifaces.size())));
        }
        try {
            SnmpValue[] results = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])oids);
            this.log().debug((Object)("got " + results.length + " SnmpValues"));
            int i = 0;
            for (SnmpValue result : results) {
                if (result != null) {
                    PollableSnmpInterface.SnmpMinimalPollInterface miface;
                    this.log().debug((Object)("Snmp Value is " + result.toInt() + " for oid: " + oids[i]));
                    if (i < mifaces.size()) {
                        miface = mifaces.get(i);
                        miface.setStatus(PollStatus.up());
                        miface.setAdminstatus(result.toInt());
                    } else {
                        miface = mifaces.get(i - mifaces.size());
                        miface.setStatus(PollStatus.up());
                        miface.setOperstatus(result.toInt());
                    }
                } else {
                    this.log().error((Object)("Snmp Value is null for oid: " + oids[i]));
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            this.log().error((Object)("Number operator used on a non-number " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            this.log().error((Object)("Invalid Snmp Criteria: " + e.getMessage()));
        }
        catch (Throwable t) {
            this.log().error((Object)("Unexpected exception during SNMP poll of interface " + agentConfig), t);
        }
        return mifaces;
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

