/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPoller;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;

final class SnmpInterfacePollerEventProcessor
implements EventListener {
    private final SnmpPoller m_poller;

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeDown");
        ueiList.add("uei.opennms.org/nodes/nodeUp");
        ueiList.add("uei.opennms.org/nodes/interfaceDown");
        ueiList.add("uei.opennms.org/nodes/interfaceUp");
        ueiList.add("uei.opennms.org/nodes/nodeLostService");
        ueiList.add("uei.opennms.org/nodes/nodeRegainedService");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        ueiList.add("uei.opennms.org/internal/capsd/addInterface");
        ueiList.add("uei.opennms.org/internal/capsd/deleteInterface");
        ueiList.add("uei.opennms.org/internal/reloadSnmpPollerConfig");
        ueiList.add("uei.opennms.org/internal/provisiond/nodeScanCompleted");
        this.getEventManager().addEventListener(this, ueiList);
    }

    SnmpInterfacePollerEventProcessor(SnmpPoller poller) {
        this.m_poller = poller;
        this.createMessageSelectorAndSubscribe();
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Subscribed to eventd");
        }
    }

    public void close() {
        this.getEventManager().removeEventListener(this);
    }

    private EventIpcManager getEventManager() {
        return this.getPoller().getEventManager();
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        Logger log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)("SnmpInterfacePollerEventProcessor: received event, uei = " + event.getUei()));
        if (event.getUei().equals("uei.opennms.org/internal/reloadSnmpPollerConfig")) {
            this.reloadConfig();
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDown")) {
            this.nodeDownHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeUp")) {
            this.nodeUpHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDown")) {
            this.interfaceDownHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceUp")) {
            this.interfaceUpHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLostService")) {
            this.serviceDownHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeRegainedService")) {
            this.serviceUpHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            this.serviceGainedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted")) {
            this.nodeDeletedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/primarySnmpInterfaceChanged")) {
            this.primarychangeHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/internal/capsd/deleteInterface") || event.getUei().equals("uei.opennms.org/internal/capsd/addInterface") || event.getUei().equals("uei.opennms.org/internal/provisiond/nodeScanCompleted")) {
            this.refreshInterfaceHandler(event);
        }
    }

    private void reloadConfig() {
        Logger log = ThreadCategory.getInstance(this.getClass());
        try {
            this.getPollerConfig().update();
            this.getPoller().getNetwork().deleteAll();
            this.getPollerConfig().rebuildPackageIpListMap();
            this.getPoller().scheduleExistingSnmpInterface();
        }
        catch (MarshalException e) {
            log.error((Object)"Update SnmpPoller configuration file failed", (Throwable)e);
        }
        catch (ValidationException e) {
            log.error((Object)"Update SnmpPoller configuration file failed", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Update SnmpPoller configuration file failed", (Throwable)e);
        }
    }

    private void primarychangeHandler(Event event) {
        this.nodeDeletedHandler(event);
        Parms parms = event.getParms();
        if (parms != null) {
            Iterator ite = parms.iterateParm();
            while (ite.hasNext()) {
                Parm parm = (Parm)ite.next();
                if (!parm.isValid() || !parm.getParmName().equals("newPrimarySnmpAddress")) continue;
                this.getPollerConfig().rebuildPackageIpListMap();
                this.getPoller().scheduleNewSnmpInterface(parm.getValue().getContent());
                return;
            }
        }
    }

    private void refreshInterfaceHandler(Event event) {
        long nodeid = event.getNodeid();
        Long nodeidlong = new Long(nodeid);
        this.getPoller().getNetwork().refresh(nodeidlong.intValue());
    }

    private void nodeDeletedHandler(Event event) {
        long nodeid = event.getNodeid();
        Long nodeidlong = new Long(nodeid);
        this.getPoller().deleteSnmpInterface(nodeidlong.intValue());
    }

    private void serviceGainedHandler(Event event) {
        if (event.getService().equals(this.getPollerConfig().getService())) {
            this.getPollerConfig().rebuildPackageIpListMap();
            this.getPoller().scheduleNewSnmpInterface(event.getInterface());
        }
    }

    private void serviceDownHandler(Event event) {
        String service = event.getService();
        String[] criticalServices = this.getPollerConfig().getCriticalServiceIds();
        for (int i = 0; i < criticalServices.length; ++i) {
            if (!criticalServices[i].equals(service)) continue;
            this.getPoller().getNetwork().suspend(event.getInterface());
        }
    }

    private void serviceUpHandler(Event event) {
        String service = event.getService();
        String[] criticalServices = this.getPollerConfig().getCriticalServiceIds();
        for (int i = 0; i < criticalServices.length; ++i) {
            if (!criticalServices[i].equals(service)) continue;
            this.getPoller().getNetwork().activate(event.getInterface());
        }
    }

    private void interfaceUpHandler(Event event) {
        this.getPoller().getNetwork().activate(event.getInterface());
    }

    private void interfaceDownHandler(Event event) {
        this.getPoller().getNetwork().suspend(event.getInterface());
    }

    private void nodeUpHandler(Event event) {
        long nodeid = event.getNodeid();
        Long nodeidlong = new Long(nodeid);
        String ipprimary = this.getPoller().getNetwork().getIp(nodeidlong.intValue());
        if (ipprimary != null) {
            this.getPoller().getNetwork().activate(ipprimary);
        }
    }

    private void nodeDownHandler(Event event) {
        long nodeid = event.getNodeid();
        Long nodeidlong = new Long(nodeid);
        String ipprimary = this.getPoller().getNetwork().getIp(nodeidlong.intValue());
        if (ipprimary != null) {
            this.getPoller().getNetwork().suspend(ipprimary);
        }
    }

    public String getName() {
        return "SnmpInterfacePoller:SnmpInterfacePollerEventProcessor";
    }

    private SnmpPoller getPoller() {
        return this.m_poller;
    }

    private SnmpInterfacePollerConfig getPollerConfig() {
        return this.getPoller().getPollerConfig();
    }
}

