/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.List;
import org.apache.log4j.Category;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmpinterfacepoller.QueryManager;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueryManager
implements QueryManager {
    String m_criteria;
    OnmsSnmpInterface m_snmpInterface;
    private Category log = ThreadCategory.getInstance(this.getClass());

    private String getCriteria() {
        return this.m_criteria;
    }

    private void setCriteria(String criteria) {
        this.m_criteria = criteria;
    }

    @Override
    public List<OnmsSnmpInterface> getSnmpInterfaces(String criteria) {
        this.setCriteria(criteria);
        BeanFactoryReference bf = BeanUtils.getBeanFactory((String)"daoContext");
        final SnmpInterfaceDao snmpInterfaceDao = (SnmpInterfaceDao)BeanUtils.getBean((BeanFactoryReference)bf, (String)"snmpInterfaceDao", SnmpInterfaceDao.class);
        TransactionTemplate transTemplate = (TransactionTemplate)BeanUtils.getBean((BeanFactoryReference)bf, (String)"transactionTemplate", TransactionTemplate.class);
        List iface = (List)transTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                OnmsCriteria onmsCriteria = new OnmsCriteria(OnmsSnmpInterface.class);
                onmsCriteria.add(Restrictions.sqlRestriction((String)DefaultQueryManager.this.getCriteria()));
                return snmpInterfaceDao.findMatching(onmsCriteria);
            }
        });
        this.log.debug((Object)("interfacce trovate: " + iface.size()));
        return iface;
    }

    @Override
    public void saveSnmpInterface(OnmsSnmpInterface snmpInterface) {
        this.setSnmpInterface(snmpInterface);
        BeanFactoryReference bf = BeanUtils.getBeanFactory((String)"daoContext");
        final SnmpInterfaceDao snmpInterfaceDao = (SnmpInterfaceDao)BeanUtils.getBean((BeanFactoryReference)bf, (String)"snmpInterfaceDao", SnmpInterfaceDao.class);
        TransactionTemplate transTemplate = (TransactionTemplate)BeanUtils.getBean((BeanFactoryReference)bf, (String)"transactionTemplate", TransactionTemplate.class);
        transTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                snmpInterfaceDao.saveOrUpdate((Object)DefaultQueryManager.this.getSnmpInterface());
                return new Object();
            }
        });
    }

    private OnmsSnmpInterface getSnmpInterface() {
        return this.m_snmpInterface;
    }

    private void setSnmpInterface(OnmsSnmpInterface snmpInterface) {
        this.m_snmpInterface = snmpInterface;
    }
}

