/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.Date;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmpinterfacepoller.QueryManager;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.opennms.netmgt.xml.event.Event;

public class DefaultPollContext
implements PollContext {
    private volatile SnmpInterfacePollerConfig m_pollerConfig;
    private volatile QueryManager m_queryManager;
    private volatile EventIpcManager m_eventManager;
    private volatile String m_name;
    private volatile String m_localHostName;

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setLocalHostName(String localHostName) {
        this.m_localHostName = localHostName;
    }

    public String getLocalHostName() {
        return this.m_localHostName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public SnmpInterfacePollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(SnmpInterfacePollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public String getServiceName() {
        return this.getPollerConfig().getService();
    }

    public void sendEvent(Event event) {
        this.getEventManager().sendNow(event);
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public Event createEvent(String uei, int nodeId, String address, Date date, OnmsSnmpInterface snmpinterface) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("createEvent: uei = " + uei + " nodeid = " + nodeId + " date = " + date));
        }
        EventBuilder bldr = new EventBuilder(uei, this.getName(), date);
        bldr.setNodeid(nodeId);
        if (address != null) {
            bldr.setInterface(address);
        }
        bldr.setService(this.getServiceName());
        bldr.setHost(this.getLocalHostName());
        bldr.setField("ifIndex", snmpinterface.getIfIndex().toString());
        bldr.addParam("snmpifindex", snmpinterface.getIfIndex().toString());
        bldr.addParam("ipaddr", snmpinterface.getIpAddress());
        if (snmpinterface.getIfName() != null) {
            bldr.addParam("snmpifname", snmpinterface.getIfName());
        }
        if (snmpinterface.getIfDescr() != null) {
            bldr.addParam("snmpifdescr", snmpinterface.getIfDescr());
        }
        if (snmpinterface.getIfAlias() != null) {
            bldr.addParam("snmpifalias", snmpinterface.getIfAlias());
        }
        if (snmpinterface.getNetMask() != null) {
            bldr.addParam("mask", snmpinterface.getNetMask());
        }
        return bldr.getEvent();
    }

    public PollableSnmpInterface refresh(PollableSnmpInterface pollsnmpinterface) {
        pollsnmpinterface.setSnmpinterfaces(this.getQueryManager().getSnmpInterfaces(pollsnmpinterface.getCriteria() + "and nodeid = " + pollsnmpinterface.getParent().getNodeid()));
        return pollsnmpinterface;
    }

    public void update(OnmsSnmpInterface snmpinterface) {
        this.getQueryManager().saveSnmpInterface(snmpinterface);
    }

    public boolean suppressAdminDownEvent() {
        return this.getPollerConfig().suppressAdminDownEvent();
    }
}

