/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class DefaultPollerSettings
implements InitializingBean,
PollerSettings {
    private final String MONITOR_ID_KEY = "locationMonitorId";
    private Resource m_configResource;
    private Properties m_settings;

    public Integer getMonitorId() {
        String monIdStr = this.m_settings.getProperty("locationMonitorId");
        return monIdStr == null ? null : Integer.decode(monIdStr);
    }

    public void setMonitorId(Integer monitorId) {
        if (monitorId == null) {
            this.m_settings.remove("locationMonitorId");
        } else {
            this.m_settings.setProperty("locationMonitorId", monitorId.toString());
        }
        this.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() {
        FileOutputStream out = null;
        try {
            try {
                File configFile = this.m_configResource.getFile();
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                out = new FileOutputStream(configFile);
                this.m_settings.store(out, "Properties File for OpenNMS Remote Poller");
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Unable to save properties to " + this.m_configResource, (Throwable)e);
            }
            Object var4_4 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        out.close();
        return;
    }

    public void setConfigurationResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_configResource, (String)"The configurationDir property must be set");
        this.m_settings = this.m_configResource.exists() ? PropertiesLoaderUtils.loadProperties((Resource)this.m_configResource) : new Properties();
    }
}

