/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.OnmsPollModel;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollerBackEnd
implements PollerBackEnd,
SpringServiceDaemon {
    private LocationMonitorDao m_locMonDao;
    private MonitoredServiceDao m_monSvcDao;
    private EventIpcManager m_eventIpcManager;
    private PollerConfig m_pollerConfig;
    private TimeKeeper m_timeKeeper;
    private int m_disconnectedTimeout;
    private Date m_configurationTimestamp = null;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_locMonDao, (String)"The LocationMonitorDao must be set");
        Assert.notNull((Object)this.m_monSvcDao, (String)"The MonitoredServiceDao must be set");
        Assert.notNull((Object)this.m_pollerConfig, (String)"The PollerConfig must be set");
        Assert.notNull((Object)this.m_timeKeeper, (String)"The timeKeeper must be set");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"The eventIpcManager must be set");
        Assert.state((this.m_disconnectedTimeout > 0 ? 1 : 0) != 0, (String)"the disconnectedTimeout property must be set");
        this.m_configurationTimestamp = this.m_timeKeeper.getCurrentDate();
    }

    public void start() throws Exception {
    }

    @Override
    public void checkForDisconnectedMonitors() {
        this.log().debug((Object)("Checking for disconnected monitors: disconnectedTimeout = " + this.m_disconnectedTimeout));
        Date now = this.m_timeKeeper.getCurrentDate();
        Date earliestAcceptable = new Date(now.getTime() - (long)this.m_disconnectedTimeout);
        List monitors = this.m_locMonDao.findAll();
        this.log().debug((Object)("Found " + monitors.size() + " monitors"));
        for (OnmsLocationMonitor monitor : monitors) {
            if (monitor.getStatus() == OnmsLocationMonitor.MonitorStatus.STARTED && monitor.getLastCheckInTime().before(earliestAcceptable)) {
                this.log().debug((Object)("Monitor " + monitor.getName() + " has stopped responding"));
                monitor.setStatus(OnmsLocationMonitor.MonitorStatus.DISCONNECTED);
                this.m_locMonDao.update((Object)monitor);
                this.sendDisconnectedEvent(monitor);
                continue;
            }
            this.log().debug((Object)("Monitor " + monitor.getName() + "(" + monitor.getStatus() + ") last responded at " + monitor.getLastCheckInTime()));
        }
    }

    private OnmsLocationMonitor.MonitorStatus checkForGlobalConfigChange(Date currentConfigurationVersion) {
        if (this.m_configurationTimestamp.after(currentConfigurationVersion)) {
            return OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
        }
        return OnmsLocationMonitor.MonitorStatus.STARTED;
    }

    @Override
    public void configurationUpdated() {
        this.m_configurationTimestamp = this.m_timeKeeper.getCurrentDate();
    }

    private EventBuilder createEventBuilder(OnmsLocationMonitor mon, String uei) {
        EventBuilder eventBuilder = new EventBuilder(uei, "PollerBackEnd").addParam("locationMonitorId", mon.getId().intValue());
        return eventBuilder;
    }

    private boolean databaseStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus == null || !currentStatus.getPollResult().equals((Object)newStatus.getPollResult());
    }

    private Date getConfigurationTimestamp() {
        return this.m_configurationTimestamp;
    }

    @Override
    public Collection<OnmsMonitoringLocationDefinition> getMonitoringLocations() {
        return this.m_locMonDao.findAllMonitoringLocationDefinitions();
    }

    @Override
    public String getMonitorName(int locationMonitorId) {
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.load((Serializable)Integer.valueOf(locationMonitorId));
        return locationMonitor.getName();
    }

    private Map<String, Object> getParameterMap(Service serviceConfig) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Enumeration serviceParms = serviceConfig.enumerateParameter();
        while (serviceParms.hasMoreElements()) {
            Parameter serviceParm = (Parameter)serviceParms.nextElement();
            String value = serviceParm.getValue();
            if (value == null) {
                value = serviceParm.getAnyObject() == null ? "" : serviceParm.getAnyObject().toString();
            }
            paramMap.put(serviceParm.getKey(), value);
        }
        return paramMap;
    }

    @Override
    public PollerConfiguration getPollerConfiguration(int locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            return new EmptyPollerConfiguration();
        }
        Package pkg = this.getPollingPackageForMonitor(mon);
        ServiceSelector selector = this.m_pollerConfig.getServiceSelectorForPackage(pkg);
        Collection services = this.m_monSvcDao.findMatchingServices(selector);
        this.log().debug((Object)("found " + services.size() + " services"));
        ArrayList<PolledService> configs = new ArrayList<PolledService>(services.size());
        for (OnmsMonitoredService monSvc : services) {
            Service serviceConfig = this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg);
            long interval = serviceConfig.getInterval();
            Map<String, Object> parameters = this.getParameterMap(serviceConfig);
            configs.add(new PolledService(monSvc, parameters, new OnmsPollModel(interval)));
        }
        PolledService[] polledSvcs = configs.toArray(new PolledService[configs.size()]);
        return new SimplePollerConfiguration(this.getConfigurationTimestamp(), polledSvcs);
    }

    private Package getPollingPackageForMonitor(OnmsLocationMonitor mon) {
        OnmsMonitoringLocationDefinition def = this.m_locMonDao.findMonitoringLocationDefinition(mon.getDefinitionName());
        if (def == null) {
            throw new IllegalStateException("Location definition '" + mon.getDefinitionName() + "' could not be found for location monitor ID " + mon.getId());
        }
        String pollingPackageName = def.getPollingPackageName();
        Package pkg = this.m_pollerConfig.getPackage(pollingPackageName);
        if (pkg == null) {
            throw new IllegalStateException("Package " + pollingPackageName + " does not exist as defined for monitoring location " + mon.getDefinitionName());
        }
        return pkg;
    }

    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        Collection<ServiceMonitorLocator> locators = this.m_pollerConfig.getServiceMonitorLocators(context);
        this.log().debug((Object)("getServiceMonitorLocators: Returning " + locators.size() + " locators"));
        return locators;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private boolean logicalStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus != null || currentStatus == null && !newStatus.getPollResult().isAvailable();
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(int locationMonitorId, Date currentConfigurationVersion) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            this.log().debug((Object)("Deleted monitor checked in with ID " + locationMonitorId));
            return OnmsLocationMonitor.MonitorStatus.DELETED;
        }
        return this.updateMonitorState(mon, currentConfigurationVersion);
    }

    @Override
    public boolean pollerStarting(int locationMonitorId, Map<String, String> pollerDetails) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            return false;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        mon.setDetails(pollerDetails);
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStartedEvent(mon);
        return true;
    }

    @Override
    public void pollerStopping(int locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            this.log().info((Object)("pollerStopping was called for location monitor ID " + locationMonitorId + " which does not exist"));
            return;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STOPPED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStoppedEvent(mon);
    }

    private void processStatusChange(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        if (this.databaseStatusChanged(currentStatus, newStatus)) {
            this.m_locMonDao.saveStatusChange(newStatus);
            PollStatus pollResult = newStatus.getPollResult();
            if (this.logicalStatusChanged(currentStatus, newStatus)) {
                this.sendRegainedOrLostServiceEvent(newStatus, pollResult);
            }
        }
    }

    @Override
    public int registerLocationMonitor(String monitoringLocationId) {
        OnmsMonitoringLocationDefinition def = this.m_locMonDao.findMonitoringLocationDefinition(monitoringLocationId);
        if (def == null) {
            throw new ObjectRetrievalFailureException(OnmsMonitoringLocationDefinition.class, (Object)monitoringLocationId, "Location monitor definition with the id '" + monitoringLocationId + "' not found", null);
        }
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setDefinitionName(def.getName());
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.REGISTERED);
        this.m_locMonDao.save((Object)mon);
        return mon.getId();
    }

    @Override
    public void reportResult(int locationMonitorID, int serviceId, PollStatus pollResult) {
        if (pollResult == null) {
            throw new IllegalArgumentException("pollResult argument cannot be null");
        }
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorID));
        if (locationMonitor == null) {
            this.log().info((Object)("reportResult was called for location monitor ID " + locationMonitorID + " which does not exist"));
            return;
        }
        OnmsMonitoredService monSvc = (OnmsMonitoredService)this.m_monSvcDao.get((Serializable)Integer.valueOf(serviceId));
        if (monSvc == null) {
            this.log().info((Object)("reportResult was called for service " + serviceId + " which does not exist on location monitor ID " + locationMonitorID));
            return;
        }
        OnmsLocationSpecificStatus newStatus = new OnmsLocationSpecificStatus(locationMonitor, monSvc, pollResult);
        if (newStatus.getPollResult().getResponseTime() != null) {
            Package pkg = this.getPollingPackageForMonitor(locationMonitor);
            this.m_pollerConfig.saveResponseTimeData(Integer.toString(locationMonitorID), monSvc, newStatus.getPollResult().getResponseTime(), pkg);
        }
        OnmsLocationSpecificStatus currentStatus = this.m_locMonDao.getMostRecentStatusChange(locationMonitor, monSvc);
        this.processStatusChange(currentStatus, newStatus);
    }

    private void sendDisconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorDisconnected");
    }

    private void sendEvent(OnmsLocationMonitor mon, String uei) {
        EventBuilder eventBuilder = this.createEventBuilder(mon, uei);
        this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
    }

    private void sendMonitorStartedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStarted");
    }

    private void sendMonitorStoppedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStopped");
    }

    private void sendReconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorReconnected");
    }

    private void sendRegainedOrLostServiceEvent(OnmsLocationSpecificStatus newStatus, PollStatus pollResult) {
        String uei = pollResult.isAvailable() ? "uei.opennms.org/remote/nodes/nodeRegainedService" : "uei.opennms.org/remote/nodes/nodeLostService";
        EventBuilder builder = this.createEventBuilder(newStatus.getLocationMonitor(), uei).setMonitoredService(newStatus.getMonitoredService());
        if (!pollResult.isAvailable() && pollResult.getReason() != null) {
            builder.addParam("eventReason", pollResult.getReason());
        }
        this.m_eventIpcManager.sendNow(builder.getEvent());
    }

    public void setDisconnectedTimeout(int disconnectedTimeout) {
        this.m_disconnectedTimeout = disconnectedTimeout;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setLocationMonitorDao(LocationMonitorDao locMonDao) {
        this.m_locMonDao = locMonDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    private OnmsLocationMonitor.MonitorStatus updateMonitorState(OnmsLocationMonitor mon, Date currentConfigurationVersion) {
        try {
            switch (mon.getStatus()) {
                case DISCONNECTED: {
                    this.sendReconnectedEvent(mon);
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = this.checkForGlobalConfigChange(currentConfigurationVersion);
                    return monitorStatus;
                }
                case STARTED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = this.checkForGlobalConfigChange(currentConfigurationVersion);
                    return monitorStatus;
                }
                case PAUSED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = OnmsLocationMonitor.MonitorStatus.PAUSED;
                    return monitorStatus;
                }
                case CONFIG_CHANGED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
                    return monitorStatus;
                }
            }
            this.log().error((Object)("Unexpected monitor state for monitor: " + mon));
            throw new IllegalStateException("Unexpected monitor state for monitor: " + mon);
        }
        finally {
            mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
            this.m_locMonDao.update((Object)mon);
        }
    }

    private static class SimplePollerConfiguration
    implements PollerConfiguration,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Date m_timestamp;
        private PolledService[] m_polledServices;

        SimplePollerConfiguration(Date timestamp, PolledService[] polledSvcs) {
            this.m_timestamp = timestamp;
            this.m_polledServices = polledSvcs;
        }

        public Date getConfigurationTimestamp() {
            return this.m_timestamp;
        }

        public PolledService[] getPolledServices() {
            return this.m_polledServices;
        }
    }
}

