/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.remote.Poller;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMonitorFactoryBean
implements FactoryBean,
InitializingBean {
    private ServiceMonitor m_serviceMonitor;
    private Class<?> m_monitorClass;
    private Map<String, Object> m_monitorParameters;

    public void setMonitorClass(Class<?> serviceClass) {
        this.m_monitorClass = serviceClass;
    }

    public void setMonitorParameters(Map<String, Object> serviceParameters) {
        this.m_monitorParameters = serviceParameters;
    }

    public Object getObject() throws Exception {
        return this.m_serviceMonitor;
    }

    public Class<?> getObjectType() {
        return this.m_monitorClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.assertNotNull(this.m_monitorClass, "monitorClass");
        Assert.state((boolean)ServiceMonitor.class.isAssignableFrom(this.m_monitorClass), (String)"monitorClass must implement the ServiceMonitor interface");
        if (this.m_monitorParameters == null) {
            this.m_monitorParameters = new HashMap<String, Object>();
        }
        this.m_serviceMonitor = (ServiceMonitor)this.m_monitorClass.newInstance();
        this.m_serviceMonitor.initialize(this.m_monitorParameters);
    }

    private void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + Poller.class));
    }
}

