/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class TcpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        tracker = new TimeoutTracker(parameters, 0, 3000);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)-1);
        if (port == -1) {
            throw new RuntimeException("TcpMonitor: required parameter 'port' is not present in supplied properties.");
        }
        strBannerMatch = (String)parameters.get("banner");
        ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker));
        }
        serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block30: {
                if (serviceStatus.isAvailable() != false) return serviceStatus;
                socket = null;
                try {
                    block32: {
                        block31: {
                            tracker.startAttempt();
                            socket = new Socket();
                            socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                            socket.setSoTimeout(tracker.getSoTimeout());
                            this.log().debug((Object)("TcpMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                            serviceStatus = PollStatus.unresponsive();
                            if (strBannerMatch != null && strBannerMatch.length() != 0 && !strBannerMatch.equals("*")) break block31;
                            serviceStatus = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                            var15_17 = null;
                            ** GOTO lbl-1000
                        }
                        rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        response = rdr.readLine();
                        responseTime = tracker.elapsedTimeInMillis();
                        if (response != null) break block32;
                        ** GOTO lbl125
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("poll: banner = " + response));
                        this.log().debug((Object)("poll: responseTime= " + responseTime + "ms"));
                    }
                    serviceStatus = response.indexOf(strBannerMatch) > -1 ? PollStatus.available((Double)responseTime) : PollStatus.unavailable((String)("Banner: '" + response + "' does not contain match string '" + strBannerMatch + "'"));
                    ** GOTO lbl137
                }
                catch (NoRouteToHostException e) {
                    serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                    var15_17 = null;
                    try {
                        if (socket == null) return serviceStatus;
                        socket.close();
                        return serviceStatus;
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled() == false) return serviceStatus;
                        this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        return serviceStatus;
                    }
                }
                catch (InterruptedIOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
                    var15_17 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block30;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block30;
                }
                catch (ConnectException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
                    var15_17 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block30;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block30;
                }
                catch (IOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
                    var15_17 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block30;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block30;
                }
                {
                    catch (Throwable var14_19) {
                        var15_17 = null;
                        ** try [egrp 2[TRYBLOCK] [20 : 660->673)] { 
lbl106:
                        // 1 sources

                        if (socket == null) throw var14_19;
                        socket.close();
                        throw var14_19;
lbl109:
                        // 1 sources

                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (this.log().isDebugEnabled() == false) throw var14_19;
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        throw var14_19;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled() == false) return serviceStatus;
                        this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        return serviceStatus;
                    }
                    if (socket == null) return serviceStatus;
                    socket.close();
                    return serviceStatus;
lbl125:
                    // 1 sources

                    var15_17 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl137:
                    // 1 sources

                    var15_17 = null;
                    ** try [egrp 2[TRYBLOCK] [20 : 660->673)] { 
lbl139:
                    // 1 sources

                    if (socket != null) {
                        socket.close();
                    }
lbl143:
                    // 1 sources

                    catch (IOException e) {}
                    e.fillInStackTrace();
                    if (!this.log().isDebugEnabled()) break block30;
                    this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

