/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class SmtpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static String LOCALHOST_NAME;
    private static RE MULTILINE;
    private RE ENDMULTILINE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        tracker = new TimeoutTracker(parameters, 0, 3000);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)25);
        ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker));
        }
        serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block57: {
                if (serviceStatus.isAvailable() != false) return serviceStatus;
                socket = null;
                try {
                    block60: {
                        block64: {
                            block63: {
                                block62: {
                                    block61: {
                                        block59: {
                                            block58: {
                                                tracker.startAttempt();
                                                socket = new Socket();
                                                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                                                socket.setSoTimeout(tracker.getSoTimeout());
                                                this.log().debug((Object)("SmtpMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                                                serviceStatus = PollStatus.unresponsive();
                                                rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                                banner = rdr.readLine();
                                                if (banner != null) break block58;
                                                var20_23 = null;
                                                ** GOTO lbl-1000
                                            }
                                            if (!SmtpMonitor.MULTILINE.match(banner)) break block59;
                                            multiLineRC = new String(banner.getBytes(), 0, 3) + " ";
                                            try {
                                                this.ENDMULTILINE = new RE(multiLineRC);
                                            }
                                            catch (RESyntaxException ex) {
                                                throw new UndeclaredThrowableException(ex);
                                            }
                                            while ((banner = rdr.readLine()) != null && !this.ENDMULTILINE.match(banner)) {
                                            }
                                            if (banner != null) break block59;
                                            ** GOTO lbl191
                                        }
                                        if (this.log().isDebugEnabled()) {
                                            this.log().debug((Object)("poll: banner = " + banner));
                                        }
                                        if ((rc = Integer.parseInt((t = new StringTokenizer(banner)).nextToken())) != 220) break block60;
                                        cmd = "HELO " + SmtpMonitor.LOCALHOST_NAME + "\r\n";
                                        socket.getOutputStream().write(cmd.getBytes());
                                        response = rdr.readLine();
                                        responseTime = tracker.elapsedTimeInMillis();
                                        if (response != null) break block61;
                                        ** GOTO lbl203
                                    }
                                    if (!SmtpMonitor.MULTILINE.match(response)) break block62;
                                    multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                                    try {
                                        this.ENDMULTILINE = new RE(multiLineRC);
                                    }
                                    catch (RESyntaxException ex) {
                                        throw new UndeclaredThrowableException(ex);
                                    }
                                    while ((response = rdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                                    }
                                    if (response != null) break block62;
                                    ** GOTO lbl215
                                }
                                if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) != 250) break block60;
                                cmd = "QUIT\r\n";
                                socket.getOutputStream().write(cmd.getBytes());
                                response = rdr.readLine();
                                if (response != null) break block63;
                                ** GOTO lbl227
                            }
                            if (!SmtpMonitor.MULTILINE.match(response)) break block64;
                            multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                            try {
                                this.ENDMULTILINE = new RE(multiLineRC);
                            }
                            catch (RESyntaxException ex) {
                                throw new UndeclaredThrowableException(ex);
                            }
                            while ((response = rdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                            }
                            if (response != null) break block64;
                            ** GOTO lbl239
                        }
                        if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 221) {
                            serviceStatus = PollStatus.available((Double)responseTime);
                        }
                    }
                    if (serviceStatus.isAvailable()) ** GOTO lbl251
                    serviceStatus = PollStatus.unavailable();
                    ** GOTO lbl251
                }
                catch (NumberFormatException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "NumberFormatException while polling address " + ipv4Addr.getHostAddress(), e);
                    var20_23 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block57;
                    }
                }
                catch (NoRouteToHostException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled() == false) return serviceStatus;
                        this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        return serviceStatus;
                    }
                    if (socket == null) return serviceStatus;
                    socket.close();
                    return serviceStatus;
                }
                catch (InterruptedIOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Did not receive expected response within timeout " + tracker);
                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block57;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block57;
                }
                catch (ConnectException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Unable to connect to address " + ipv4Addr.getHostAddress(), e);
                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block57;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block57;
                }
                catch (IOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address " + ipv4Addr.getHostAddress(), e);
                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        break block57;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block57;
                }
                {
                    catch (Throwable var19_27) {
                        var20_23 = null;
                        ** try [egrp 5[TRYBLOCK] [51 : 1070->1083)] { 
lbl171:
                        // 1 sources

                        if (socket == null) throw var19_27;
                        socket.close();
                        throw var19_27;
lbl174:
                        // 1 sources

                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (this.log().isDebugEnabled() == false) throw var19_27;
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                        throw var19_27;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl191:
                    // 1 sources

                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl203:
                    // 1 sources

                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl215:
                    // 1 sources

                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl227:
                    // 1 sources

                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl239:
                    // 1 sources

                    var20_23 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl251:
                    // 2 sources

                    var20_23 = null;
                    ** try [egrp 5[TRYBLOCK] [51 : 1070->1083)] { 
lbl253:
                    // 1 sources

                    if (socket != null) {
                        socket.close();
                    }
lbl257:
                    // 1 sources

                    catch (IOException e) {}
                    e.fillInStackTrace();
                    if (!this.log().isDebugEnabled()) break block57;
                    this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    static {
        MULTILINE = null;
        try {
            LOCALHOST_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            ThreadCategory.getInstance(SmtpMonitor.class).error((Object)"Failed to resolve localhost name, using localhost");
            LOCALHOST_NAME = "localhost";
        }
        try {
            MULTILINE = new RE("^[0-9]{3}-");
        }
        catch (RESyntaxException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

