/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.apache.log4j.Level;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class SmbMonitor
extends IPv4Monitor {
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        NbtAddress nbtAddr = null;
        try {
            nbtAddr = NbtAddress.getByName((String)ipv4Addr.getHostAddress());
            if (!nbtAddr.getHostName().equals(ipv4Addr.getHostAddress())) {
                serviceStatus = PollStatus.available();
            }
        }
        catch (UnknownHostException uhE) {
            serviceStatus = this.logDown(Level.DEBUG, "Unknown host exception generated for " + ipv4Addr.toString() + ", reason: " + uhE.getLocalizedMessage());
        }
        catch (RuntimeException rE) {
            serviceStatus = this.logDown(Level.ERROR, "Unexpected runtime exception", rE);
        }
        catch (Exception e) {
            serviceStatus = this.logDown(Level.DEBUG, "Unexpected exception", e);
        }
        return serviceStatus;
    }
}

