/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientManager;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public class NsclientMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String reason = null;
        int serviceStatus = 3;
        NsclientPacket response = null;
        Double responseTime = null;
        NetworkInterface iface = svc.getNetInterface();
        Logger log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        String command = ParameterMap.getKeyedString(parameters, (String)"command", (String)NsclientManager.convertTypeToString("1"));
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)NsclientManager.DEFAULT_PORT);
        String password = ParameterMap.getKeyedString(parameters, (String)"password", (String)"None");
        String params = ParameterMap.getKeyedString(parameters, (String)"parameter", null);
        int critPerc = ParameterMap.getKeyedInteger(parameters, (String)"criticalPercent", (int)0);
        int warnPerc = ParameterMap.getKeyedInteger(parameters, (String)"warningPercent", (int)0);
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            try {
                tracker.startAttempt();
                NsclientManager client = new NsclientManager(ipv4Addr.getHostAddress(), port, password);
                client.setTimeout(tracker.getSoTimeout());
                client.setPassword(password);
                client.init();
                NsclientCheckParams clientParams = new NsclientCheckParams(critPerc, warnPerc, params);
                response = client.processCheckCommand(NsclientManager.convertStringToType(command), clientParams);
                responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    if (response.getResultCode() == 0) {
                        serviceStatus = 1;
                        reason = response.getResponse();
                    } else if (response.getResultCode() == 2) {
                        serviceStatus = 2;
                        reason = response.getResponse();
                        responseTime = null;
                    }
                }
            }
            catch (NsclientException e) {
                log.debug((Object)("Nsclient Poller received exception from client: " + e.getMessage()));
                reason = "NsclientException: " + e.getMessage();
            }
            tracker.nextAttempt();
        }
        return PollStatus.get((int)serviceStatus, reason, responseTime);
    }
}

