/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class DominoIIOPMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 63148;
    private static final int DEFAULT_IORPORT = 80;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        iface = svc.getNetInterface();
        log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        tracker = new TimeoutTracker(parameters, 3, 3000);
        IORport = ParameterMap.getKeyedInteger(parameters, (String)"ior-port", (int)80);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)63148);
        ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker));
        }
        try {
            this.retrieveIORText(ipv4Addr.getHostAddress(), IORport);
        }
        catch (Exception e) {
            return this.logDown(Level.DEBUG, "failed to get the corba IOR from " + ipv4Addr, e);
        }
        status = null;
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block28: {
                if (status.isAvailable() != false) return status;
                socket = null;
                try {
                    try {
                        tracker.startAttempt();
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                        socket.setSoTimeout(tracker.getSoTimeout());
                        log.debug((Object)("DominoIIOPMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                        var11_12 = PollStatus.up((Double)tracker.elapsedTimeInMillis());
                        var13_17 = null;
                    }
                    catch (NoRouteToHostException e) {
                        status = this.logDown(Level.WARN, " No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                        var13_17 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                            }
                            break block28;
                        }
                    }
                    catch (InterruptedIOException e) {
                        status = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
                        var13_17 = null;
                        try {}
                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                            }
                            break block28;
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        break block28;
                    }
                    catch (ConnectException e) {
                        status = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr + " : " + e.getMessage());
                        var13_17 = null;
                        try {}
                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                            }
                            break block28;
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        break block28;
                    }
                    catch (IOException e) {
                        status = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr + " : " + e.getMessage());
                        var13_17 = null;
                        ** try [egrp 3[TRYBLOCK] [11 : 499->512)] { 
lbl83:
                        // 1 sources

                        if (socket != null) {
                            socket.close();
                        }
                        break block28;
lbl87:
                        // 1 sources

                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (!log.isDebugEnabled()) break block28;
                            log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                        }
                        break block28;
                    }
                }
                catch (Throwable var12_19) {
                    var13_17 = null;
                    ** try [egrp 3[TRYBLOCK] [11 : 499->512)] { 
lbl97:
                    // 1 sources

                    if (socket == null) throw var12_19;
                    socket.close();
                    throw var12_19;
lbl100:
                    // 1 sources

                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (log.isDebugEnabled() == false) throw var12_19;
                        log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                    }
                    throw var12_19;
                }
                try {}
                catch (IOException e) {
                    e.fillInStackTrace();
                    if (log.isDebugEnabled() == false) return var11_12;
                    log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                    return var11_12;
                }
                if (socket == null) return var11_12;
                socket.close();
                return var11_12;
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private String retrieveIORText(String host, int port) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + host + ":" + port + "/diiop_ior.txt");
        InputStream is = u.openStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!(IOR = IOR + line).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        if (!IOR.startsWith("IOR:")) {
            throw new IOException("Invalid IOR: " + IOR);
        }
        return IOR;
    }
}

