/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.protocols.dns.DNSAddressRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class DnsMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 53;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 5000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)53);
        String lookup = ParameterMap.getKeyedString(parameters, (String)"lookup", null);
        if (lookup == null || lookup.length() == 0) {
            try {
                lookup = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ukE) {
                ukE.fillInStackTrace();
                throw new UndeclaredThrowableException(ukE);
            }
        }
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        DNSAddressRequest request = new DNSAddressRequest(lookup);
        PollStatus serviceStatus = PollStatus.unavailable();
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(timeoutTracker.getSoTimeout());
            timeoutTracker.reset();
            while (timeoutTracker.shouldRetry() && !serviceStatus.isAvailable()) {
                try {
                    byte[] data = request.buildRequest();
                    DatagramPacket outgoing = new DatagramPacket(data, data.length, ipv4Addr, port);
                    byte[] buffer = new byte[512];
                    DatagramPacket incoming = new DatagramPacket(buffer, buffer.length);
                    timeoutTracker.startAttempt();
                    socket.send(outgoing);
                    socket.receive(incoming);
                    double responseTime = timeoutTracker.elapsedTimeInMillis();
                    request.verifyResponse(incoming.getData(), incoming.getLength());
                    serviceStatus = this.logUp(Level.DEBUG, responseTime, "valid DNS request received, responseTime= " + responseTime + "ms");
                }
                catch (InterruptedIOException ex) {
                }
                catch (NoRouteToHostException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address: " + ipv4Addr, e);
                }
                catch (ConnectException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
                }
                catch (IOException ex) {
                    serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, ex);
                }
                timeoutTracker.nextAttempt();
            }
        }
        catch (IOException ex) {
            serviceStatus = this.logDown(Level.DEBUG, "Failed to create Datagram Socket for : " + ipv4Addr, ex);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return serviceStatus;
    }
}

