/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dhcpd.Dhcpd;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class DhcpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Logger log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)0);
        int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DhcpMonitor.poll: address: " + ipv4Addr + " timeout: " + timeout + " retry: " + retry));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        try {
            responseTime = Dhcpd.isServer(ipv4Addr, timeout, retry);
            if (responseTime >= 0L) {
                serviceStatus = PollStatus.available((Double)Double.valueOf(responseTime));
            }
        }
        catch (IOException ioE) {
            ioE.fillInStackTrace();
            serviceStatus = this.logDown(Level.WARN, "An I/O exception occured during DHCP discovery", ioE);
        }
        return serviceStatus;
    }
}

