/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class CitrixMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 1494;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)1494);
        InetAddress ipv4Addr = svc.getAddress();
        String host = ipv4Addr.getHostAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("CitrixMonitor.poll: Polling interface: " + host + timeoutTracker));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry() && !serviceStatus.isAvailable()) {
            Socket socket = null;
            try {
                timeoutTracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeoutTracker.getConnectionTimeout());
                socket.setSoTimeout(timeoutTracker.getSoTimeout());
                this.log().debug((Object)("CitrixMonitor: connected to host: " + host + " on port: " + port));
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                StringBuffer buffer = new StringBuffer();
                while (!serviceStatus.isAvailable()) {
                    buffer.append((char)reader.read());
                    if (buffer.toString().indexOf("ICA") > -1) {
                        serviceStatus = PollStatus.available((Double)timeoutTracker.elapsedTimeInMillis());
                        continue;
                    }
                    serviceStatus = PollStatus.unavailable((String)"magic cookie 'ICA' missing from service greeting.");
                }
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection refused by host " + host, e);
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.INFO, "Unable to test host " + host + ", no route available", e);
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host " + host + " within timeout: " + timeoutTracker);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.INFO, "Error communicating with host " + host, e);
            }
            catch (Throwable t) {
                serviceStatus = this.logDown(Level.WARN, "Undeclared throwable exception caught contacting host " + host, t);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                }
                catch (IOException e) {}
            }
            timeoutTracker.nextAttempt();
        }
        return serviceStatus;
    }
}

