/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class BgpSessionMonitor
extends SnmpMonitorStrategy {
    private static final String m_serviceName = "BGP_Session";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private static final String BGP_PEER_STATE_OID = ".1.3.6.1.2.1.15.3.1.2";
    private static final String BGP_PEER_ADMIN_STATE_OID = ".1.3.6.1.2.1.15.3.1.3";
    private static final String BGP_PEER_REMOTEAS_OID = ".1.3.6.1.2.1.15.3.1.9";
    private static final String BGP_PEER_LAST_ERROR_OID = ".1.3.6.1.2.1.15.3.1.14";
    private static final String BGP_PEER_FSM_EST_TIME_OID = ".1.3.6.1.2.1.15.3.1.16";

    public String serviceName() {
        return m_serviceName;
    }

    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        super.initialize(svc);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: SnmpAgentConfig address: " + agentConfig));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: BgpSessionMonitor setting SNMP peer attribute for interface " + ipAddr.getHostAddress()));
        }
        iface.setAttribute(SNMP_AGENTCONFIG_KEY, (Object)agentConfig);
        this.log().debug((Object)("initialize: interface: " + agentConfig.getAddress() + " initialized."));
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String returnValue = new String();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        String adminStateMsg = "N/A";
        String peerStateMsg = "N/A";
        String remoteAsMsg = "N/A";
        String lastErrorMsg = "N/A";
        String estTimeMsg = "N/A";
        SnmpAgentConfig agentConfig = (SnmpAgentConfig)iface.getAttribute(SNMP_AGENTCONFIG_KEY);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String bgpPeerIp = ParameterMap.getKeyedString(parameters, (String)"bgpPeerIp", null);
        if (bgpPeerIp == null) {
            this.log().warn((Object)"poll: No BGP-Peer IP Defined! ");
            return status;
        }
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        try {
            SnmpObjId bgpPeerStateSnmpObject;
            SnmpValue bgpPeerState;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("poll: SnmpAgentConfig address: " + agentConfig));
            }
            if ((bgpPeerState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)(bgpPeerStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.2." + bgpPeerIp))))) == null) {
                this.log().warn((Object)"No BGP peer state received!");
                return status;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("poll: bgpPeerState: " + bgpPeerState));
            }
            peerStateMsg = this.resolvePeerState(bgpPeerState.toInt());
            if (bgpPeerState.toInt() == BGP_PEER_STATE.ESTABLISHED.value()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("poll: bgpPeerState: " + BGP_PEER_STATE.ESTABLISHED.name()));
                }
                return PollStatus.available();
            }
            SnmpObjId bgpPeerAdminStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.3." + bgpPeerIp));
            SnmpValue bgpPeerAdminState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerAdminStateSnmpObject);
            if (bgpPeerAdminState == null) {
                this.log().warn((Object)"Cannot receive bgpAdminState");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("poll: bgpPeerAdminState: " + bgpPeerAdminState));
                }
                adminStateMsg = this.resolveAdminState(bgpPeerAdminState.toInt());
            }
            SnmpObjId bgpPeerRemoteAsSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.9." + bgpPeerIp));
            SnmpValue bgpPeerRemoteAs = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerRemoteAsSnmpObject);
            if (bgpPeerRemoteAs == null) {
                this.log().warn((Object)"Cannot receive bgpPeerRemoteAs");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("poll: bgpPeerRemoteAs: " + bgpPeerRemoteAs));
                }
                remoteAsMsg = bgpPeerRemoteAs.toString();
            }
            SnmpObjId bgpPeerLastErrorSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.14." + bgpPeerIp));
            SnmpValue bgpPeerLastError = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerLastErrorSnmpObject);
            if (bgpPeerLastError == null) {
                this.log().warn((Object)"Cannot receive bgpPeerLastError");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("poll: bgpPeerLastError: " + bgpPeerLastError));
                }
                lastErrorMsg = this.resolveBgpErrorCode(bgpPeerLastError.toHexString());
            }
            SnmpObjId bgpPeerFsmEstTimeSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.16." + bgpPeerIp));
            SnmpValue bgpPeerFsmEstTime = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerFsmEstTimeSnmpObject);
            if (bgpPeerFsmEstTime == null) {
                this.log().warn((Object)"Cannot receive bgpPeerFsmEstTime");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("poll: bgpPeerFsmEsmTime: " + bgpPeerFsmEstTime));
                }
                estTimeMsg = bgpPeerFsmEstTime.toString();
            }
            returnValue = "BGP Session state to AS-" + remoteAsMsg + " via " + bgpPeerIp + " is " + peerStateMsg + "! Last peer " + "error message is " + lastErrorMsg + ". BGP admin state is " + adminStateMsg + ". BGP Session established time: " + estTimeMsg;
            status = PollStatus.unavailable((String)returnValue);
        }
        catch (NullPointerException e) {
            status = this.logDown(Level.WARN, "Unexpected error during SNMP poll of interface " + ipaddr.getHostAddress(), e);
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.WARN, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.WARN, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }

    private String resolveBgpErrorCode(String bgpCode) {
        String clearCode = "unknown error";
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("0100", "Message Header Error");
        codeMap.put("0101", "Message Header Error - Connection Not Synchronized");
        codeMap.put("0102", "Message Header Error - Bad Message Length");
        codeMap.put("0103", "Message Header Error - Bad Message Type");
        codeMap.put("0200", "OPEN Message Error");
        codeMap.put("0201", "OPEN Message Error - Unsupported Version Number");
        codeMap.put("0202", "OPEN Message Error - Bad Peer AS");
        codeMap.put("0203", "OPEN Message Error - Bad BGP Identifier");
        codeMap.put("0204", "OPEN Message Error - Unsupported Optional Parameter");
        codeMap.put("0205", "OPEN Message Error (deprecated)");
        codeMap.put("0206", "OPEN Message Error - Unacceptable Hold Time");
        codeMap.put("0300", "UPDATE Message Error");
        codeMap.put("0301", "UPDATE Message Error - Malformed Attribute List");
        codeMap.put("0302", "UPDATE Message Error - Unrecognized Well-known Attribute");
        codeMap.put("0303", "UPDATE Message Error - Missing Well-known Attribute");
        codeMap.put("0304", "UPDATE Message Error - Attribute Flags Error");
        codeMap.put("0305", "UPDATE Message Error - Attribute Length Error");
        codeMap.put("0306", "UPDATE Message Error - Invalid ORIGIN Attribute");
        codeMap.put("0307", "UPDATE Message Error (deprecated)");
        codeMap.put("0308", "UPDATE Message Error - Invalid NEXT_HOP Attribute");
        codeMap.put("0309", "UPDATE Message Error - Optional Attribute Error");
        codeMap.put("030A", "UPDATE Message Error - Invalid Network Field");
        codeMap.put("030B", "UPDATE Message Error - Malformed AS_PATH");
        codeMap.put("0400", "Hold Timer Expired");
        codeMap.put("0500", "Finite State Machine Error");
        codeMap.put("0600", "Cease");
        codeMap.put("0601", "Cease - Maximum Number of Prefixes Reached");
        codeMap.put("0602", "Cease - Administrative Shutdown");
        codeMap.put("0603", "Cease - Peer De-configured");
        codeMap.put("0604", "Cease - Administrative Reset");
        codeMap.put("0605", "Cease - Connection Rejected");
        codeMap.put("0606", "Cease - Other Configuration Change");
        codeMap.put("0607", "Cease - Connection Collision Resolution");
        codeMap.put("0608", "Cease - Out of Resources");
        if (codeMap.containsKey(bgpCode)) {
            clearCode = (String)codeMap.get(bgpCode);
        }
        return clearCode;
    }

    private String resolveAdminState(int sc) {
        String name = "UNKNOWN";
        if (BGP_PEER_ADMIN_STATE.STOP.value() == sc) {
            name = BGP_PEER_ADMIN_STATE.STOP.name();
        }
        if (BGP_PEER_ADMIN_STATE.START.value() == sc) {
            name = BGP_PEER_ADMIN_STATE.START.name();
        }
        return name;
    }

    private String resolvePeerState(int sc) {
        String name = "UNKNOWN";
        if (BGP_PEER_STATE.IDLE.value() == sc) {
            name = BGP_PEER_STATE.IDLE.name();
        }
        if (BGP_PEER_STATE.CONNECT.value() == sc) {
            name = BGP_PEER_STATE.CONNECT.name();
        }
        if (BGP_PEER_STATE.ACTIVE.value() == sc) {
            name = BGP_PEER_STATE.ACTIVE.name();
        }
        if (BGP_PEER_STATE.OPEN_SENT.value() == sc) {
            name = BGP_PEER_STATE.OPEN_SENT.name();
        }
        if (BGP_PEER_STATE.OPEN_CONFIRM.value() == sc) {
            name = BGP_PEER_STATE.OPEN_CONFIRM.name();
        }
        if (BGP_PEER_STATE.ESTABLISHED.value() == sc) {
            name = BGP_PEER_STATE.ESTABLISHED.name();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BGP_PEER_ADMIN_STATE {
        STOP(1),
        START(2);

        private final int state;

        private BGP_PEER_ADMIN_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BGP_PEER_STATE {
        IDLE(1),
        CONNECT(2),
        ACTIVE(3),
        OPEN_SENT(4),
        OPEN_CONFIRM(5),
        ESTABLISHED(6);

        private final int state;

        private BGP_PEER_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

