/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.passive.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.passive.PassiveStatusKeeper;
import org.opennms.netmgt.passive.jmx.PassiveStatusdMBean;

public class PassiveStatusd
implements PassiveStatusdMBean {
    public static final String LOG4J_CATEGORY = "OpenNMS.PassiveStatus";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Logger log = ThreadCategory.getInstance();
        try {
            DataSourceFactory.init();
        }
        catch (MarshalException e) {
            log.error((Object)"Could not unmarshall configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            log.error((Object)"validation error ", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IOException: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to initialize database: " + e.getMessage()), (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"SQLException: ", (Throwable)e);
        }
        catch (PropertyVetoException e) {
            log.error((Object)("PropertyVetoException: " + e.getMessage()), (Throwable)e);
        }
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        PassiveStatusKeeper keeper = this.getPassiveStatusKeeper();
        keeper.setEventManager(mgr);
        keeper.setDataSource(DataSourceFactory.getInstance());
        keeper.init();
    }

    public void start() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getPassiveStatusKeeper().start();
    }

    public void stop() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getPassiveStatusKeeper().stop();
    }

    public int getStatus() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return this.getPassiveStatusKeeper().getStatus();
    }

    public String status() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    private PassiveStatusKeeper getPassiveStatusKeeper() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return PassiveStatusKeeper.getInstance();
    }
}

