/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;

public class XMPPNotificationManager {
    private Properties props;
    private static final String LOG4J_CATEGORY = "OpenNMS.Notifd";
    private static final String XMPP_RESOURCE = "notifd";
    private static final String TRUST_STORE_PASSWORD = "changeit";
    private static final String XMPP_PORT = "5222";
    private static XMPPConnection xmpp = null;
    private static ConnectionConfiguration xmppConfig = null;
    private String xmppServer;
    private String xmppServiceName;
    private String xmppUser;
    private String xmppPassword;
    private int xmppPort;
    private HashMap<String, MultiUserChat> rooms;
    private static XMPPNotificationManager instance = null;
    private ConnectionListener conlistener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected XMPPNotificationManager() {
        block14: {
            FileInputStream fis;
            this.props = new Properties();
            this.conlistener = new ConnectionListener(){

                public void connectionClosed() {
                    XMPPNotificationManager.this.log().debug((Object)"XMPP connection closed");
                }

                public void connectionClosedOnError(Exception e) {
                    XMPPNotificationManager.this.log().warn((Object)"XMPP connection closed", (Throwable)e);
                }

                public void reconnectingIn(int seconds) {
                    if (XMPPNotificationManager.this.log().isDebugEnabled()) {
                        XMPPNotificationManager.this.log().debug((Object)("XMPP reconnecting in " + seconds + " seconds"));
                    }
                }

                public void reconnectionFailed(Exception e) {
                    XMPPNotificationManager.this.log().warn((Object)"XMPP reconnection failed", (Throwable)e);
                    xmpp.disconnect();
                    instance = null;
                }

                public void reconnectionSuccessful() {
                    XMPPNotificationManager.this.log().debug((Object)"XMPP reconnection succeeded");
                }
            };
            ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
            File config = null;
            try {
                config = ConfigFileConstants.getFile((int)ConfigFileConstants.XMPP_CONFIG_FILE_NAME);
            }
            catch (IOException e) {
                this.log().warn((Object)(ConfigFileConstants.XMPP_CONFIG_FILE_NAME + " not readable"), (Throwable)e);
            }
            if (Boolean.getBoolean("useSystemXMPPConfig") || !config.canRead()) {
                this.props = System.getProperties();
            } else {
                fis = null;
                fis = new FileInputStream(config);
                this.props.load(fis);
                IOUtils.closeQuietly((InputStream)fis);
            }
            break block14;
            catch (IOException e) {
                try {
                    this.log().warn((Object)("unable to load " + config), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        this.xmppServer = this.props.getProperty("xmpp.server");
        this.xmppServiceName = this.props.getProperty("xmpp.servicename", this.xmppServer);
        this.xmppUser = this.props.getProperty("xmpp.user");
        this.xmppPassword = this.props.getProperty("xmpp.pass");
        this.xmppPort = Integer.valueOf(this.props.getProperty("xmpp.port", XMPP_PORT));
        xmppConfig = new ConnectionConfiguration(this.xmppServer, this.xmppPort, this.xmppServiceName);
        boolean debuggerEnabled = Boolean.parseBoolean(this.props.getProperty("xmpp.debuggerEnabled"));
        xmppConfig.setDebuggerEnabled(debuggerEnabled);
        if (debuggerEnabled) {
            this.log().setLevel(Level.DEBUG);
        }
        xmppConfig.setSASLAuthenticationEnabled(Boolean.parseBoolean(this.props.getProperty("xmpp.SASLEnabled", "true")));
        xmppConfig.setSelfSignedCertificateEnabled(Boolean.parseBoolean(this.props.getProperty("xmpp.selfSignedCertificateEnabled")));
        if (Boolean.parseBoolean(this.props.getProperty("xmpp.TLSEnabled"))) {
            xmppConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
        } else {
            xmppConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
        }
        if (this.props.containsKey("xmpp.truststorePassword")) {
            xmppConfig.setTruststorePassword(this.props.getProperty("xmpp.truststorePassword"));
        } else {
            xmppConfig.setTruststorePassword(TRUST_STORE_PASSWORD);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("XMPP Manager connection config: " + xmppConfig.toString()));
        }
        xmpp = new XMPPConnection(xmppConfig);
        this.connectToServer();
    }

    private void connectToServer() {
        try {
            this.log().debug((Object)("Attempting vanilla XMPP Connection to " + this.xmppServer + ":" + this.xmppPort));
            xmpp.connect();
            if (xmpp.isConnected()) {
                this.log().debug((Object)"XMPP Manager successfully connected");
                if (xmpp.isSecureConnection()) {
                    this.log().debug((Object)"XMPP Manager successfully nogotiated a secure connection");
                }
                if (xmpp.isUsingTLS()) {
                    this.log().debug((Object)"XMPP Manager successfully nogotiated a TLS connection");
                }
                this.log().debug((Object)"XMPP Manager Connected");
                this.login();
                xmpp.addConnectionListener(this.conlistener);
            } else {
                this.log().debug((Object)"XMPP Manager Not Connected");
            }
        }
        catch (Exception e) {
            this.log().fatal((Object)"XMPP Manager unable to connect", (Throwable)e);
        }
    }

    private void login() {
        try {
            if (xmpp.isConnected()) {
                this.log().debug((Object)"XMPP Manager logging in");
                xmpp.login(this.xmppUser, this.xmppPassword, XMPP_RESOURCE);
                this.rooms = new HashMap();
            } else {
                this.log().debug((Object)"XMPP Manager unable to login: Not connected to XMPP server");
            }
        }
        catch (Exception e) {
            this.log().fatal((Object)"XMPP Manager unable to login: ", (Throwable)e);
        }
    }

    public static synchronized XMPPNotificationManager getInstance() {
        if (instance == null) {
            instance = new XMPPNotificationManager();
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return xmpp.isAuthenticated();
    }

    public boolean sendMessage(String xmppTo, String xmppMessage) {
        if (!this.isLoggedIn()) {
            this.connectToServer();
        }
        try {
            ChatManager cm = xmpp.getChatManager();
            cm.createChat(xmppTo, (MessageListener)new NullMessageListener()).sendMessage(xmppMessage);
            this.log().debug((Object)("XMPP Manager sent message to: " + xmppTo));
        }
        catch (XMPPException e) {
            this.log().fatal((Object)"XMPP Exception Sending message ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean sendGroupChat(String xmppChatRoom, String xmppMessage) {
        MultiUserChat groupChat;
        if (this.rooms.containsKey(xmppChatRoom)) {
            groupChat = this.rooms.get(xmppChatRoom);
        } else {
            this.log().debug((Object)("Adding room: " + xmppChatRoom));
            groupChat = new MultiUserChat(xmpp, xmppChatRoom);
            this.rooms.put(xmppChatRoom, groupChat);
        }
        if (!groupChat.isJoined()) {
            this.log().debug((Object)("Joining room: " + xmppChatRoom));
            try {
                groupChat.join(this.xmppUser);
            }
            catch (XMPPException e) {
                this.log().fatal((Object)"XMPP Exception joining chat room ", (Throwable)e);
                return false;
            }
        }
        try {
            groupChat.sendMessage(xmppMessage);
            this.log().debug((Object)("XMPP Manager sent message to: " + xmppChatRoom));
        }
        catch (XMPPException e) {
            this.log().fatal((Object)"XMPP Exception sending message to Chat room", (Throwable)e);
            return false;
        }
        return true;
    }

    protected Category log() {
        return ThreadCategory.getInstance();
    }

    private static class NullMessageListener
    implements MessageListener {
        private NullMessageListener() {
        }

        public void processMessage(Chat chat, Message message) {
        }
    }
}

