/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.config.DestinationPathManager;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationCommandManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.notifd.Queue;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NoticeQueue;
import org.opennms.netmgt.notifd.NotifdQueueHandler;

public final class Notifd
extends AbstractServiceDaemon {
    private static final Notifd m_singleton = new Notifd();
    private final Map<String, NoticeQueue> m_noticeQueues = new HashMap<String, NoticeQueue>();
    private final Map<String, NotifdQueueHandler> m_queueHandlers = new HashMap<String, NotifdQueueHandler>();
    private volatile BroadcastEventProcessor m_eventReader;
    private volatile EventIpcManager m_eventManager;
    private volatile NotifdConfigManager m_configManager;
    private volatile NotificationManager m_notificationManager;
    private volatile GroupManager m_groupManager;
    private volatile UserManager m_userManager;
    private volatile DestinationPathManager m_destinationPathManager;
    private volatile NotificationCommandManager m_notificationCommandManager;
    private volatile PollOutagesConfigManager m_pollOutagesConfigManager;
    private volatile NodeDao m_nodeDao;

    protected Notifd() {
        super("OpenNMS.Notifd");
    }

    protected void onInit() {
        this.m_eventReader = new BroadcastEventProcessor();
        try {
            Queue[] queues;
            this.log().info((Object)("Notification status = " + this.getConfigManager().getNotificationStatus()));
            for (Queue queue : queues = this.getConfigManager().getConfiguration().getQueue()) {
                NoticeQueue curQueue = new NoticeQueue();
                Class<?> handlerClass = Class.forName(queue.getHandlerClass().getName());
                NotifdQueueHandler handlerQueue = (NotifdQueueHandler)handlerClass.newInstance();
                handlerQueue.setQueueID(queue.getQueueId());
                handlerQueue.setNoticeQueue(curQueue);
                handlerQueue.setInterval(queue.getInterval());
                this.m_noticeQueues.put(queue.getQueueId(), curQueue);
                this.m_queueHandlers.put(queue.getQueueId(), handlerQueue);
            }
        }
        catch (Throwable t) {
            this.log().error((Object)"start: Failed to load notifd queue handlers.", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_eventReader.setDestinationPathManager(this.getDestinationPathManager());
        this.m_eventReader.setEventManager(this.getEventManager());
        this.m_eventReader.setGroupManager(this.getGroupManager());
        this.m_eventReader.setNoticeQueues(this.m_noticeQueues);
        this.m_eventReader.setNotifdConfigManager(this.getConfigManager());
        this.m_eventReader.setNotificationCommandManager(this.getNotificationCommandManager());
        this.m_eventReader.setNotificationManager(this.getNotificationManager());
        this.m_eventReader.setPollOutagesConfigManager(this.getPollOutagesConfigManager());
        this.m_eventReader.setUserManager(this.getUserManager());
        try {
            this.m_eventReader.init();
        }
        catch (Exception e) {
            this.log().error((Object)"Failed to setup event receiver", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public NotifdConfigManager getConfigManager() {
        return this.m_configManager;
    }

    public void setConfigManager(NotifdConfigManager manager) {
        this.m_configManager = manager;
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public void setGroupManager(GroupManager manager) {
        this.m_groupManager = manager;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager manager) {
        this.m_userManager = manager;
    }

    public DestinationPathManager getDestinationPathManager() {
        return this.m_destinationPathManager;
    }

    public void setDestinationPathManager(DestinationPathManager manager) {
        this.m_destinationPathManager = manager;
    }

    public NotificationCommandManager getNotificationCommandManager() {
        return this.m_notificationCommandManager;
    }

    public void setNotificationCommandManager(NotificationCommandManager manager) {
        this.m_notificationCommandManager = manager;
    }

    public NotificationManager getNotificationManager() {
        return this.m_notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.m_notificationManager = notificationManager;
    }

    public BroadcastEventProcessor getBroadcastEventProcessor() {
        return this.m_eventReader;
    }

    protected void onStart() {
        for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
            curHandler.start();
        }
    }

    protected void onStop() {
        try {
            for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
                curHandler.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.close();
        }
        this.m_eventReader = null;
    }

    protected void onPause() {
        for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
            curHandler.pause();
        }
    }

    protected void onResume() {
        for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
            curHandler.resume();
        }
    }

    public static Notifd getInstance() {
        return m_singleton;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setPollOutagesConfigManager(PollOutagesConfigManager configManager) {
        this.m_pollOutagesConfigManager = configManager;
    }

    public PollOutagesConfigManager getPollOutagesConfigManager() {
        return this.m_pollOutagesConfigManager;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }
}

