/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.notifd.NotificationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMailNotificationStrategy
implements NotificationStrategy {
    @Override
    public int send(List<Argument> arguments) {
        this.log().debug((Object)"In the JavaMailNotification class.");
        try {
            JavaMailer jm = this.buildMessage(arguments);
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            this.log().error((Object)"send: Error sending notification.", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private JavaMailer buildMessage(List<Argument> arguments) throws JavaMailerException {
        JavaMailer jm = new JavaMailer();
        for (int i = 0; i < arguments.size(); ++i) {
            Argument arg = arguments.get(i);
            this.log().debug((Object)("Current arg switch: " + i + " of " + arguments.size() + " is: " + arg.getSwitch()));
            this.log().debug((Object)("Current arg  value: " + i + " of " + arguments.size() + " is: " + arg.getValue()));
            if ("-email".equals(arg.getSwitch())) {
                this.log().debug((Object)"Found: PARAM_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-pemail".equals(arg.getSwitch())) {
                this.log().debug((Object)"Found: PARAM_PAGER_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-subject".equals(arg.getSwitch())) {
                this.log().debug((Object)"Found: PARAM_SUBJECT");
                jm.setSubject(arg.getValue());
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            this.log().debug((Object)"Found: PARAM_TEXT_MSG");
            jm.setMessageText(arg.getValue());
        }
        return jm;
    }
}

