/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeConverter;
import org.opennms.netmgt.notifd.NoticeQueue;
import org.opennms.netmgt.notifd.NotifdQueueHandler;
import org.opennms.netmgt.notifd.NotificationTask;

public class DefaultQueueHandler
implements NotifdQueueHandler {
    private NoticeQueue m_noticeQueue;
    private String m_queueID;
    private long m_interval;
    private int m_status = 0;

    public void setQueueID(String queueID) {
        this.m_queueID = queueID;
    }

    public synchronized void setNoticeQueue(NoticeQueue noticeQueue) {
        this.m_noticeQueue = noticeQueue;
    }

    public void setInterval(String interval) {
        this.m_interval = TimeConverter.convertToMillis((String)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DefaultQueueHandler defaultQueueHandler = this;
        synchronized (defaultQueueHandler) {
            this.m_status = 2;
        }
        while (true) {
            defaultQueueHandler = this;
            synchronized (defaultQueueHandler) {
                if (this.m_status == 3 || this.m_status == 4) {
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    this.m_status = 2;
                }
            }
            this.processQueue();
            defaultQueueHandler = this;
            synchronized (defaultQueueHandler) {
                try {
                    this.wait(this.m_interval);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
        defaultQueueHandler = this;
        synchronized (defaultQueueHandler) {
            this.m_status = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (this.m_noticeQueue != null) {
            NoticeQueue noticeQueue = this.m_noticeQueue;
            synchronized (noticeQueue) {
                try {
                    Long now = new Long(System.currentTimeMillis());
                    SortedMap readyNotices = this.m_noticeQueue.headMap(now);
                    for (List list : readyNotices.values()) {
                        for (NotificationTask task : list) {
                            this.startTask(task);
                        }
                    }
                    readyNotices.clear();
                    log.debug((Object)"current state of tree: ");
                    log.debug((Object)("\n" + this.m_noticeQueue));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void startTask(NotificationTask task) {
        if (!task.isStarted()) {
            task.start();
        }
    }

    public synchronized void start() {
        this.m_status = 1;
        Thread thread = new Thread((Runnable)this, this.m_queueID);
        thread.start();
    }

    public synchronized void stop() {
        if (this.m_status != 4) {
            this.m_status = 3;
        }
        this.notifyAll();
    }

    public synchronized void pause() {
        if (this.m_status == 2 || this.m_status == 7) {
            this.m_status = 5;
            this.notifyAll();
        }
    }

    public synchronized void resume() {
        if (this.m_status == 6 || this.m_status == 5) {
            this.m_status = 7;
            this.notifyAll();
        }
    }

    public String getName() {
        return this.m_queueID;
    }

    public synchronized int getStatus() {
        return this.m_status;
    }
}

