/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;

public final class Dot1dStpGroup
extends AggregateTracker {
    public static final String STP_PROTOCOL_SPEC = "dot1dStpProtocolSpecification";
    public static final String STP_PRIORITY = "dot1dStpPriority";
    public static final String STP_TIME_LASTTOPCH = "dot1dStpTimeSinceLastTopologyChange";
    public static final String STP_TOP_CHANGES = "dot1dStpTopChanges";
    public static final String STP_DESIGNATED_ROOT = "dot1dStpDesignatedRoot";
    public static final String STP_ROOT_COST = "dot1dStpRootCost";
    public static final String STP_ROOT_PORT = "dot1dStpRootPort";
    public static final String STP_MAX_AGE = "dot1dStpMaxAge";
    public static final String STP_HELLO_TIME = "dot1dStpHelloTime";
    public static final String STP_HOLD_TIME = "dot1dStpHoldTime";
    public static final String STP_FORW_DELAY = "dot1dStpForwardDelay";
    public static final String STP_BRDG_MAX_AGE = "dot1dStpBridgeMaxAge";
    public static final String STP_BRDG_HELLO_TIME = "dot1dStpBridgeHelloTime";
    public static final String STP_BRDG_FORW_DELAY = "dot1dStpBridgeForwardDelay";
    private static NamedSnmpVar[] ms_elemList = null;
    public static final String SYSTEM_OID = ".1.3.6.1.2.1.17.2";
    private SnmpStore m_store;
    private InetAddress m_address;

    public Dot1dStpGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        this.log().warn((Object)("Error retrieving systemGroup from " + this.m_address + ". " + msg));
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info((Object)("Error retrieving systemGroup from " + this.m_address + ". " + msg));
    }

    private final Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public int getStpProtocolSpecification() {
        Integer stpProtocolSpecification = this.m_store.getInt32(STP_PROTOCOL_SPEC);
        if (stpProtocolSpecification == null) {
            return -1;
        }
        return stpProtocolSpecification;
    }

    public int getStpPriority() {
        Integer stpPriority = this.m_store.getInt32(STP_PRIORITY);
        if (stpPriority == null) {
            return -1;
        }
        return stpPriority;
    }

    public SnmpValue getStpTimeSinceLastTopologyChange() {
        return this.m_store.getValue(STP_TIME_LASTTOPCH);
    }

    public int getStpTopologyChanges() {
        return this.m_store.getInt32(STP_TOP_CHANGES);
    }

    public String getStpDesignatedRoot() {
        return this.m_store.getHexString(STP_DESIGNATED_ROOT);
    }

    public int getStpRootCost() {
        Integer stpRootCost = this.m_store.getInt32(STP_ROOT_COST);
        if (stpRootCost == null) {
            return -1;
        }
        return stpRootCost;
    }

    public int getStpRootPort() {
        Integer stpRootPort = this.m_store.getInt32(STP_ROOT_PORT);
        if (stpRootPort == null) {
            return -1;
        }
        return stpRootPort;
    }

    public int getStpMaxAge() {
        Integer stpMaxAge = this.m_store.getInt32(STP_MAX_AGE);
        if (stpMaxAge == null) {
            return -1;
        }
        return stpMaxAge;
    }

    public int getStpHelloTime() {
        Integer stpHelloTime = this.m_store.getInt32(STP_HELLO_TIME);
        if (stpHelloTime == null) {
            return -1;
        }
        return stpHelloTime;
    }

    public int getStpHoldTime() {
        Integer stpHoldTime = this.m_store.getInt32(STP_HOLD_TIME);
        if (stpHoldTime == null) {
            return -1;
        }
        return stpHoldTime;
    }

    public int getStpForwardDelay() {
        Integer stpForwardDelay = this.m_store.getInt32(STP_FORW_DELAY);
        if (stpForwardDelay == null) {
            return -1;
        }
        return stpForwardDelay;
    }

    public int getStpBridgeMaxAge() {
        Integer stpBridgeMaxAge = this.m_store.getInt32(STP_BRDG_MAX_AGE);
        if (stpBridgeMaxAge == null) {
            return -1;
        }
        return stpBridgeMaxAge;
    }

    public int getStpBridgeHelloTime() {
        Integer stpBridgeHelloTime = this.m_store.getInt32(STP_BRDG_HELLO_TIME);
        if (stpBridgeHelloTime == null) {
            return -1;
        }
        return stpBridgeHelloTime;
    }

    public int getStpBridgeForwardDelay() {
        Integer stpBridgeForwardDelay = this.m_store.getInt32(STP_BRDG_FORW_DELAY);
        if (stpBridgeForwardDelay == null) {
            return -1;
        }
        return stpBridgeForwardDelay;
    }

    static {
        ms_elemList = new NamedSnmpVar[14];
        int ndx = 0;
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_PROTOCOL_SPEC, ".1.3.6.1.2.1.17.2.1");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_PRIORITY, ".1.3.6.1.2.1.17.2.2");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpTimeTicks", STP_TIME_LASTTOPCH, ".1.3.6.1.2.1.17.2.3");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpCounter32", STP_TOP_CHANGES, ".1.3.6.1.2.1.17.2.4");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", STP_DESIGNATED_ROOT, ".1.3.6.1.2.1.17.2.5");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_ROOT_COST, ".1.3.6.1.2.1.17.2.6");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_ROOT_PORT, ".1.3.6.1.2.1.17.2.7");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_MAX_AGE, ".1.3.6.1.2.1.17.2.8");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_HELLO_TIME, ".1.3.6.1.2.1.17.2.9");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_HOLD_TIME, ".1.3.6.1.2.1.17.2.10");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_FORW_DELAY, ".1.3.6.1.2.1.17.2.11");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_BRDG_MAX_AGE, ".1.3.6.1.2.1.17.2.12");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_BRDG_HELLO_TIME, ".1.3.6.1.2.1.17.2.13");
        Dot1dStpGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", STP_BRDG_FORW_DELAY, ".1.3.6.1.2.1.17.2.14");
    }
}

