/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.Vlan;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.CdpCacheTable;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTable;
import org.opennms.netmgt.linkd.snmp.IpRouteTable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnmpCollection
implements ReadyRunnable {
    public static final String TRUNK_VLAN_NAME = "AllVlans";
    public static final int TRUNK_VLAN_INDEX = 0;
    public static final String DEFAULT_VLAN_NAME = "default";
    public static final int DEFAULT_VLAN_INDEX = 1;
    private SnmpAgentConfig m_agentConfig;
    private final InetAddress m_address;
    private String m_vlanClass = null;
    private boolean m_collectVlanTable = false;
    private boolean m_collectIpRouteTable = false;
    private boolean m_collectStpNode = false;
    private boolean m_saveStpNodeTable = false;
    private boolean m_saveIpRouteTable = false;
    private boolean m_saveStpInterfaceTable = false;
    private boolean m_collectStpTable = false;
    private boolean m_collectBridgeForwardingTable = false;
    private boolean m_collectCdpTable = false;
    public IpNetToMediaTable m_ipNetToMedia;
    public IpRouteTable m_ipRoute;
    public CdpCacheTable m_CdpCache;
    public SnmpTable<SnmpTableEntry> m_vlanTable;
    public Map<Vlan, SnmpVlanCollection> m_snmpVlanCollection;
    private Scheduler m_scheduler;
    private long poll_interval = 1800000L;
    private long initial_sleep_time = 600000L;
    private boolean suspendCollection = false;
    private boolean runned = false;
    private String packageName;

    SnmpCollection() {
        throw new UnsupportedOperationException("default constructor not supported");
    }

    public SnmpCollection(SnmpAgentConfig config) {
        this.m_agentConfig = config;
        this.m_address = this.m_agentConfig.getAddress();
        this.m_ipNetToMedia = null;
        this.m_ipRoute = null;
        this.m_vlanTable = null;
        this.m_CdpCache = null;
        this.m_snmpVlanCollection = new HashMap<Vlan, SnmpVlanCollection>();
    }

    boolean failed() {
        return !this.hasIpNetToMediaTable() && !this.hasRouteTable() && !this.hasCdpCacheTable() && !this.hasVlanTable();
    }

    boolean hasIpNetToMediaTable() {
        return this.m_ipNetToMedia != null && !this.m_ipNetToMedia.failed();
    }

    IpNetToMediaTable getIpNetToMediaTable() {
        return this.m_ipNetToMedia;
    }

    boolean hasRouteTable() {
        return this.m_ipRoute != null && !this.m_ipRoute.failed();
    }

    IpRouteTable getIpRouteTable() {
        return this.m_ipRoute;
    }

    boolean hasCdpCacheTable() {
        return this.m_CdpCache != null && !this.m_CdpCache.failed();
    }

    CdpCacheTable getCdpCacheTable() {
        return this.m_CdpCache;
    }

    boolean hasVlanTable() {
        return this.m_vlanTable != null && !this.m_vlanTable.failed();
    }

    SnmpTable<SnmpTableEntry> getVlanTable() {
        return this.m_vlanTable;
    }

    public String getVlanName(int m_vlan) {
        if (this.hasVlanTable()) {
            for (SnmpTableEntry ent : this.getVlanTable().getEntries()) {
                int vlanIndex = ent.getInt32("vtpVlanIndex");
                if (vlanIndex != m_vlan) continue;
                return ent.getDisplayString("vtpVlanName");
            }
        }
        return null;
    }

    public int getVlanIndex(String m_vlanname) {
        if (this.hasVlanTable()) {
            for (SnmpTableEntry ent : this.getVlanTable().getEntries()) {
                String vlanName = ent.getDisplayString("vtpVlanName");
                if (!vlanName.equals(m_vlanname)) continue;
                return ent.getInt32("vtpVlanIndex");
            }
        }
        return -1;
    }

    Map<Vlan, SnmpVlanCollection> getSnmpVlanCollections() {
        return this.m_snmpVlanCollection;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            this.log().debug((Object)("SnmpCollection.run: address: " + this.m_address.getHostAddress() + " Suspended!"));
        } else {
            this.m_ipNetToMedia = new IpNetToMediaTable(this.m_address);
            this.m_ipRoute = new IpRouteTable(this.m_address);
            this.m_CdpCache = new CdpCacheTable(this.m_address);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("run: collecting : " + this.m_agentConfig));
            }
            SnmpWalker walker = null;
            if (this.m_collectVlanTable) {
                Class<?> vlanGetter = null;
                try {
                    vlanGetter = Class.forName(this.m_vlanClass);
                }
                catch (ClassNotFoundException e) {
                    this.log().error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class not found " + e));
                }
                Class[] classes = new Class[]{InetAddress.class};
                Constructor<?> constr = null;
                try {
                    constr = vlanGetter.getConstructor(classes);
                }
                catch (NoSuchMethodException e) {
                    this.log().error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class has not such method " + e));
                }
                catch (SecurityException s) {
                    this.log().error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class security violation " + s));
                }
                Object[] argum = new Object[]{this.m_address};
                try {
                    this.m_vlanTable = (SnmpTable)((Object)constr.newInstance(argum));
                }
                catch (InvocationTargetException t) {
                    this.log().error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class Invocation Exception " + t));
                }
                catch (InstantiationException i) {
                    this.log().error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class Instantiation Exception " + i));
                }
                catch (IllegalAccessException s) {
                    this.log().error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class Illegal Access Exception " + s));
                }
            }
            walker = this.m_collectVlanTable && this.m_collectIpRouteTable && this.m_collectCdpTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/ipRouteTable/cdpCacheTable/vlanTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_ipRoute, this.m_CdpCache, this.m_vlanTable}) : (this.m_collectCdpTable && this.m_collectIpRouteTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/ipRouteTable/cdpCacheTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_ipRoute, this.m_CdpCache}) : (this.m_collectVlanTable && this.m_collectIpRouteTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/ipRouteTable/vlanTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_ipRoute, this.m_vlanTable}) : (this.m_collectVlanTable && this.m_collectCdpTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/vlanTable/cdpCacheTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_vlanTable, this.m_CdpCache}) : (this.m_collectIpRouteTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/ipRouteTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_ipRoute}) : (this.m_collectVlanTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/vlanTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_vlanTable}) : (this.m_collectCdpTable ? SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/cdpCacheTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_CdpCache}) : SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia})))))));
            walker.start();
            try {
                walker.waitFor();
            }
            catch (InterruptedException e) {
                this.m_ipNetToMedia = null;
                this.m_ipRoute = null;
                this.m_CdpCache = null;
                this.m_vlanTable = null;
                this.log().error((Object)"SnmpCollection.run: collection interrupted, exiting", (Throwable)e);
                return;
            }
            if (!this.hasIpNetToMediaTable()) {
                this.log().info((Object)("SnmpCollection.run: failed to collect ipNetToMediaTable for " + this.m_address.getHostAddress()));
            }
            if (!this.hasRouteTable()) {
                this.log().info((Object)("SnmpCollection.run: failed to collect ipRouteTable for " + this.m_address.getHostAddress()));
            }
            if (!this.hasCdpCacheTable()) {
                this.log().info((Object)("SnmpCollection.run: failed to collect dpCacheTable for " + this.m_address.getHostAddress()));
            }
            if (this.m_collectVlanTable && !this.hasVlanTable()) {
                this.log().info((Object)("SnmpCollection.run: failed to collect Vlan for " + this.m_address.getHostAddress()));
            }
            Object vlan = null;
            if (this.hasVlanTable()) {
                if (!this.m_vlanClass.equals("org.opennms.netmgt.linkd.snmp.CiscoVlanTable") && !this.m_vlanClass.equals("org.opennms.netmgt.linkd.snmp.IntelVlanTable")) {
                    this.runAndSaveSnmpVlanCollection(new Vlan(0, TRUNK_VLAN_NAME, 1));
                } else {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("SnmpCollection.run: start collection for " + this.getVlanTable().getEntries().size() + " VLAN entries "));
                    }
                    for (SnmpTableEntry ent : this.m_vlanTable.getEntries()) {
                        Integer type;
                        Integer status;
                        int vlanindex = ent.getInt32("vtpVlanIndex");
                        if (vlanindex == -1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)"SnmpCollection.run: found null value for vlan.");
                            continue;
                        }
                        String vlanname = ent.getDisplayString("vtpVlanName");
                        if (vlanname == null) {
                            vlanname = DEFAULT_VLAN_NAME;
                        }
                        if ((status = ent.getInt32("vtpVlanStatus")) == null || status != 1) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info((Object)("SnmpCollection.run: skipping VLAN " + vlan + " NOT ACTIVE or null "));
                            continue;
                        }
                        String community = this.m_agentConfig.getReadCommunity();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("SnmpCollection.run: peer community: " + community + " with VLAN " + vlan));
                        }
                        if ((type = ent.getInt32("vtpVlanType")) == null || type != 1) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info((Object)("SnmpCollection.run: skipping VLAN " + vlan + " NOT ETHERNET TYPE"));
                            continue;
                        }
                        this.m_agentConfig.setReadCommunity(community + "@" + vlanindex);
                        this.runAndSaveSnmpVlanCollection(new Vlan(vlanindex, vlanname, status));
                        this.m_agentConfig.setReadCommunity(community);
                    }
                }
            } else {
                this.runAndSaveSnmpVlanCollection(new Vlan(1, DEFAULT_VLAN_NAME, 1));
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"SnmpCollection.run: saving collection into database ");
            }
            Linkd.getInstance().updateNodeSnmpCollection(this);
            this.m_ipNetToMedia = null;
            this.m_ipRoute = null;
            this.m_CdpCache = null;
            this.m_vlanTable = null;
            this.m_snmpVlanCollection.clear();
        }
        this.reschedule();
        this.runned = true;
    }

    private void runAndSaveSnmpVlanCollection(Vlan vlan) {
        SnmpVlanCollection snmpvlancollection = new SnmpVlanCollection(this.m_agentConfig, this.m_collectStpNode, this.m_collectStpTable, this.m_collectBridgeForwardingTable);
        snmpvlancollection.run();
        if (snmpvlancollection.failed()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"SnmpCollection.run: no bridge info found");
            }
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"SnmpCollection.run: adding bridge info to snmpcollection");
            }
            this.m_snmpVlanCollection.put(vlan, snmpvlancollection);
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    public long getPollInterval() {
        return this.poll_interval;
    }

    public void setPollInterval(long interval) {
        this.poll_interval = interval;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.poll_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.poll_interval, this);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.unschedule(this, this.poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.poll_interval + this.initial_sleep_time);
        }
    }

    public String getVlanClass() {
        return this.m_vlanClass;
    }

    public void setVlanClass(String className) {
        if (className == null || className.equals("")) {
            return;
        }
        this.m_vlanClass = className;
        this.m_collectVlanTable = true;
    }

    public InetAddress getTarget() {
        return this.m_address;
    }

    public boolean collectVlanTable() {
        return this.m_collectVlanTable;
    }

    public String getReadCommunity() {
        return this.m_agentConfig.getReadCommunity();
    }

    public SnmpAgentConfig getPeer() {
        return this.m_agentConfig;
    }

    public int getPort() {
        return this.m_agentConfig.getPort();
    }

    @Override
    public boolean equals(ReadyRunnable run) {
        SnmpCollection c;
        return run instanceof SnmpCollection && this.getPackageName().equals(run.getPackageName()) && (c = (SnmpCollection)run).getTarget().equals(this.m_address) && c.getPort() == this.getPort() && c.getReadCommunity().equals(this.getReadCommunity());
    }

    @Override
    public String getInfo() {
        return "Ready Runnable(s) SnmpCollection  ip=" + this.getTarget() + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName() + " collectBridgeForwardingTable=" + this.getCollectBridgeForwardingTable() + " collectStpNode=" + this.getCollectStpNode() + " collectStpTable=" + this.getCollectStpTable() + " collectCdpTable=" + this.getCollectCdpTable() + " collectIpRouteTable=" + this.getCollectIpRouteTable() + " saveIpRouteTable=" + this.getSaveIpRouteTable() + " saveStpInterfaceTable=" + this.getSaveStpInterfaceTable() + " saveStpNodeTable=" + this.getSaveStpNodeTable();
    }

    public boolean getCollectBridgeForwardingTable() {
        return this.m_collectBridgeForwardingTable;
    }

    public void collectBridgeForwardingTable(boolean bridgeForwardingTable) {
        this.m_collectBridgeForwardingTable = bridgeForwardingTable;
    }

    public boolean getCollectCdpTable() {
        return this.m_collectCdpTable;
    }

    public void collectCdpTable(boolean cdpTable) {
        this.m_collectCdpTable = cdpTable;
    }

    public boolean getCollectIpRouteTable() {
        return this.m_collectIpRouteTable;
    }

    public void collectIpRouteTable(boolean ipRouteTable) {
        this.m_collectIpRouteTable = ipRouteTable;
    }

    public boolean getCollectStpNode() {
        return this.m_collectStpNode;
    }

    public void collectStpNode(boolean stpNode) {
        this.m_collectStpNode = stpNode;
    }

    public boolean getCollectStpTable() {
        return this.m_collectStpTable;
    }

    public void collectStpTable(boolean stpTable) {
        this.m_collectStpTable = stpTable;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean getSaveStpNodeTable() {
        return this.m_saveStpNodeTable;
    }

    public void saveStpNodeTable(boolean stpNodeTable) {
        this.m_saveStpNodeTable = stpNodeTable;
    }

    public boolean getSaveIpRouteTable() {
        return this.m_saveIpRouteTable;
    }

    public void SaveIpRouteTable(boolean ipRouteTable) {
        this.m_saveIpRouteTable = ipRouteTable;
    }

    public boolean getSaveStpInterfaceTable() {
        return this.m_saveStpInterfaceTable;
    }

    public void saveStpInterfaceTable(boolean stpInterfaceTable) {
        this.m_saveStpInterfaceTable = stpInterfaceTable;
    }
}

