/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.eventd.db.AutoAction;
import org.opennms.netmgt.eventd.db.Constants;
import org.opennms.netmgt.eventd.db.Correlation;
import org.opennms.netmgt.eventd.db.Forward;
import org.opennms.netmgt.eventd.db.OperatorAction;
import org.opennms.netmgt.eventd.db.Parameter;
import org.opennms.netmgt.eventd.db.SnmpInfo;
import org.opennms.netmgt.eventd.processor.AbstractJdbcPersister;
import org.opennms.netmgt.eventd.processor.EventProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Operaction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public final class JdbcEventWriter
extends AbstractJdbcPersister
implements EventProcessor,
InitializingBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Header eventHeader, Event event) throws SQLException, DataAccessException {
        if (!this.checkEventSanityAndDoWeProcess(event, "JdbcEventWriter")) {
            return;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("JdbcEventWriter: processing " + event.getUei() + " nodeid: " + event.getNodeid() + " ipaddr: " + event.getInterface() + " serviceid: " + event.getService()));
        }
        Connection connection = this.getDataSource().getConnection();
        try {
            connection.setAutoCommit(false);
            try {
                this.insertEvent(eventHeader, event, connection);
                connection.commit();
            }
            catch (SQLException e) {
                this.log().warn((Object)("JdbcEventWriter: Error inserting event into the datastore: " + e), (Throwable)e);
                try {
                    connection.rollback();
                }
                catch (Exception e2) {
                    this.log().warn((Object)("JdbcEventWriter: Rollback of transaction failed: " + e2), (Throwable)e2);
                }
                throw e;
            }
            catch (DataAccessException e) {
                this.log().warn((Object)("JdbcEventWriter: Error inserting event into the datastore: " + (Object)((Object)e)), (Throwable)e);
                try {
                    connection.rollback();
                }
                catch (Exception e2) {
                    this.log().warn((Object)("JdbcEventWriter: Rollback of transaction failed: " + e2), (Throwable)e2);
                }
                throw e;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log().warn((Object)("JdbcEventWriter: SQLException while closing database connection: " + e), (Throwable)e);
            }
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            this.log().warn((Object)("JdbcEventWriter: SQLException while closing database connection: " + e), (Throwable)e);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("JdbcEventWriter: EventWriter finished for : " + event.getUei()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEvent(Header eventHeader, Event event, Connection connection) throws SQLException {
        int eventID = this.getNextId();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("EventWriter: DBID: " + eventID));
        }
        Event event2 = event;
        synchronized (event2) {
            event.setDbid(eventID);
        }
        DBUtils d = new DBUtils(this.getClass());
        try {
            String parametersString;
            PreparedStatement insStmt = connection.prepareStatement("INSERT into events (eventID, eventUei, nodeID, eventTime, eventHost, ipAddr, eventDpName, eventSnmpHost, serviceID, eventSnmp, eventParms, eventCreateTime, eventDescr, eventLoggroup, eventLogmsg, eventLog, eventDisplay, eventSeverity, eventPathOutage, eventCorrelation, eventSuppressedCount, eventOperInstruct, eventAutoAction, eventOperAction, eventOperActionMenuText, eventNotification, eventTticket, eventTticketState, eventForward, eventMouseOverText, eventAckUser, eventAckTime, eventSource,ifIndex) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            d.watch((Object)insStmt);
            insStmt.setInt(1, eventID);
            insStmt.setString(2, Constants.format(event.getUei(), 256));
            int nodeid = (int)event.getNodeid();
            this.set(insStmt, 3, event.hasNodeid() ? nodeid : -1);
            insStmt.setTimestamp(4, this.getEventTime(event));
            String hostname = this.getEventHost(event, connection);
            this.set(insStmt, 5, Constants.format(hostname, 256));
            this.set(insStmt, 6, Constants.format(event.getInterface(), 16));
            insStmt.setString(7, eventHeader != null ? Constants.format(eventHeader.getDpName(), 12) : "undefined");
            this.set(insStmt, 8, Constants.format(event.getSnmphost(), 256));
            this.set(insStmt, 9, this.getEventServiceId(event));
            if (event.getSnmp() != null) {
                insStmt.setString(10, SnmpInfo.format(event.getSnmp(), 256));
            } else {
                insStmt.setNull(10, 12);
            }
            String string = parametersString = event.getParms() != null ? Parameter.format(event.getParms()) : null;
            if (parametersString != null) {
                parametersString = parametersString.replace('\u0000', ' ');
            }
            this.set(insStmt, 11, parametersString);
            if (event.hasIfIndex() && event.getParms() != null) {
                Parameter.format(event.getParms());
            }
            Timestamp eventCreateTime = new Timestamp(System.currentTimeMillis());
            insStmt.setTimestamp(12, eventCreateTime);
            this.set(insStmt, 13, Constants.format(event.getDescr(), 4000));
            this.set(insStmt, 14, event.getLoggroupCount() > 0 ? Constants.format(event.getLoggroup(), 32) : null);
            if (event.getLogmsg() != null) {
                this.set(insStmt, 15, Constants.format(event.getLogmsg().getContent(), 256));
                String logdest = event.getLogmsg().getDest();
                if (logdest.equals("logndisplay")) {
                    this.set(insStmt, 16, 'Y');
                    this.set(insStmt, 17, 'Y');
                } else if (logdest.equals("logonly")) {
                    this.set(insStmt, 16, 'Y');
                    this.set(insStmt, 17, 'N');
                } else if (logdest.equals("displayonly")) {
                    this.set(insStmt, 16, 'N');
                    this.set(insStmt, 17, 'Y');
                } else if (logdest.equals("suppress")) {
                    this.set(insStmt, 16, 'N');
                    this.set(insStmt, 17, 'N');
                }
            } else {
                insStmt.setNull(15, 12);
                this.set(insStmt, 17, 'Y');
            }
            this.set(insStmt, 18, Constants.getSeverity((String)event.getSeverity()));
            this.set(insStmt, 19, event.getPathoutage() != null ? Constants.format(event.getPathoutage(), 1024) : null);
            this.set(insStmt, 20, event.getCorrelation() != null ? Correlation.format(event.getCorrelation(), 1024) : null);
            insStmt.setNull(21, 4);
            this.set(insStmt, 22, Constants.format(event.getOperinstruct(), 1024));
            this.set(insStmt, 23, event.getAutoactionCount() > 0 ? AutoAction.format(event.getAutoaction(), 256) : null);
            if (event.getOperactionCount() > 0) {
                ArrayList<Operaction> a = new ArrayList<Operaction>();
                ArrayList<String> b = new ArrayList<String>();
                for (Operaction eoa : event.getOperactionCollection()) {
                    a.add(eoa);
                    b.add(eoa.getMenutext());
                }
                this.set(insStmt, 24, OperatorAction.format(a, 256));
                this.set(insStmt, 25, Constants.format(b, 64));
            } else {
                insStmt.setNull(24, 12);
                insStmt.setNull(25, 12);
            }
            insStmt.setNull(26, 12);
            if (event.getTticket() != null) {
                this.set(insStmt, 27, Constants.format(event.getTticket().getContent(), 128));
                int ttstate = 0;
                if (event.getTticket().getState().equals("on")) {
                    ttstate = 1;
                }
                this.set(insStmt, 28, ttstate);
            } else {
                insStmt.setNull(27, 12);
                insStmt.setNull(28, 4);
            }
            this.set(insStmt, 29, event.getForwardCount() > 0 ? Forward.format(event.getForward(), 256) : null);
            this.set(insStmt, 30, Constants.format(event.getMouseovertext(), 64));
            if (event.getAutoacknowledge() != null && event.getAutoacknowledge().getState().equals("on")) {
                this.set(insStmt, 31, Constants.format(event.getAutoacknowledge().getContent(), 256));
                this.set(insStmt, 32, eventCreateTime);
            } else {
                insStmt.setNull(31, 4);
                insStmt.setNull(32, 93);
            }
            this.set(insStmt, 33, Constants.format(event.getSource(), 128));
            if (event.hasIfIndex()) {
                this.set(insStmt, 34, event.getIfIndex());
            } else {
                insStmt.setNull(34, 4);
            }
            insStmt.executeUpdate();
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("SUCCESSFULLY added " + event.getUei() + " related  data into the EVENTS table"));
        }
    }

    String getHostName(int nodeId, String hostip, Connection connection) throws SQLException {
        try {
            String hostname = (String)new SimpleJdbcTemplate(this.getDataSource()).queryForObject("SELECT ipHostname FROM ipinterface WHERE nodeId = ? AND ipAddr = ?", String.class, new Object[]{nodeId, hostip});
            return hostname != null ? hostname : hostip;
        }
        catch (EmptyResultDataAccessException e) {
            return hostip;
        }
    }

    private int getEventServiceId(Event event) {
        if (event.getService() == null) {
            return -1;
        }
        try {
            return this.getServiceID(event.getService());
        }
        catch (Throwable t) {
            this.log().warn((Object)("EventWriter.add: Error converting service name \"" + event.getService() + "\" to an integer identifier, storing -1.  Error: " + t), t);
            return -1;
        }
    }

    protected String getEventHost(Event event, Connection connection) {
        if (event.getHost() == null) {
            return null;
        }
        if (!event.hasNodeid()) {
            return event.getHost();
        }
        try {
            return this.getHostName((int)event.getNodeid(), event.getHost(), connection);
        }
        catch (Throwable t) {
            this.log().warn((Object)("EventWriter.add: Error converting host IP \"" + event.getHost() + "\" to a hostname, storing the IP.  Error: " + t), t);
            return event.getHost();
        }
    }
}

