/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.eventd.db.Constants;
import org.opennms.netmgt.eventd.db.Parameter;
import org.opennms.netmgt.eventd.processor.AbstractJdbcPersister;
import org.opennms.netmgt.eventd.processor.EventProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.util.Assert;

@Deprecated
public final class JdbcAlarmWriter
extends AbstractJdbcPersister
implements EventProcessor,
InitializingBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Header eventHeader, Event event) throws SQLException {
        if (!this.checkEventSanityAndDoWeProcess(event, "JdbcAlarmWriter")) {
            return;
        }
        if (event.getAlarmData() == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("JdbcAlarmWriter: uei '" + event.getUei() + "' does not have alarm data; not processing into an alarm."));
            }
            return;
        }
        Assert.isTrue((event.getDbid() > 0 ? 1 : 0) != 0, (String)"event does not have a dbid");
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("JdbcAlarmWriter dbRun for : " + event.getUei() + " nodeid: " + event.getNodeid() + " ipaddr: " + event.getInterface() + " serviceid: " + event.getService()));
        }
        boolean updated = false;
        for (int attempt = 1; attempt <= 2 && !updated; ++attempt) {
            Connection connection;
            block25: {
                SQLException e3;
                block24: {
                    Object var9_8;
                    connection = this.getDataSource().getConnection();
                    try {
                        connection.setAutoCommit(false);
                        int alarmId = this.isReductionNeeded(eventHeader, event, connection);
                        if (alarmId != -1) {
                            if (this.log().isDebugEnabled()) {
                                this.log().debug((Object)("JdbcAlarmWriter: Reducing event for " + event.getDbid() + " with UEI " + event.getUei()));
                            }
                            this.updateAlarm(eventHeader, event, alarmId, connection);
                            if (event.getAlarmData().getAutoClean()) {
                                this.log().debug((Object)("JdbcAlarmWriter: deleting previous events for alarm " + alarmId));
                                this.cleanPreviousEvents(alarmId, event.getDbid(), connection);
                            }
                            updated = true;
                        } else {
                            if (this.log().isDebugEnabled()) {
                                this.log().debug((Object)("JdbcAlarmWriter: Inserting new alarm (not reducing) for event " + event.getDbid() + " with UEI " + event.getUei()));
                            }
                            try {
                                this.insertAlarm(eventHeader, event, connection);
                                updated = true;
                            }
                            catch (DataIntegrityViolationException e2) {
                                if (attempt > 1) {
                                    this.log().error((Object)("JdbcAlarmWriter: Error in attempt: " + attempt + " inserting alarm for event " + event.getDbid() + " into the datastore: " + (Object)((Object)e2)), (Throwable)e2);
                                    throw e2;
                                }
                                this.log().info((Object)("JdbcAlarmWriter: Retrying processing of alarm for event " + event.getDbid() + " after first attempt: " + ((Object)((Object)e2)).getClass() + ": " + e2.getMessage()));
                            }
                        }
                        var9_8 = null;
                        if (!updated) break block24;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (updated) {
                            try {
                                connection.commit();
                            }
                            catch (SQLException e3) {
                                this.log().error((Object)("JdbcAlarmWriter: Commit of transaction failed: " + e3), (Throwable)e3);
                            }
                        } else {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException e3) {
                                this.log().error((Object)("JdbcAlarmWriter: Rollback of transaction failed: " + e3), (Throwable)e3);
                            }
                        }
                        connection.close();
                        throw throwable;
                    }
                    try {
                        connection.commit();
                    }
                    catch (SQLException e3) {
                        this.log().error((Object)("JdbcAlarmWriter: Commit of transaction failed: " + e3), (Throwable)e3);
                    }
                    break block25;
                }
                try {
                    connection.rollback();
                    break block25;
                }
                catch (SQLException e3) {
                    this.log().error((Object)("JdbcAlarmWriter: Rollback of transaction failed: " + e3), (Throwable)e3);
                }
                {
                }
            }
            connection.close();
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("AlarmWriter finished for event " + event.getDbid() + " with UEI " + event.getUei()));
        }
    }

    private void insertAlarm(Header eventHeader, Event event, Connection connection) throws SQLException {
        int alarmID = -1;
        alarmID = this.getNextId();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("AlarmWriter: DBID: " + alarmID));
        }
        DBUtils d = new DBUtils(this.getClass());
        try {
            try {
                String parametersString;
                PreparedStatement insStmt = connection.prepareStatement("INSERT  INTO alarms (alarmID, eventUei, dpName, nodeID, ipaddr,                serviceID, reductionKey, alarmType, counter, severity,                lastEventID, firstEventTime, lastEventTime, description, logMsg,                operInstruct, tticketID, tticketState, mouseOverText, suppressedUntil,                suppressedUser, suppressedTime, alarmAckUser, alarmAckTime, clearUei,                x733AlarmType, x733ProbableCause, clearKey, ifIndex, eventParms) VALUES (?,?,?,?,?,        ?,?,?,?,?,        ?,?,?,        ?,?,?,?,        ?,?,?,        ?,?,?,?,?,        ?,?,?,?,?)");
                d.watch((Object)insStmt);
                insStmt.setInt(1, alarmID);
                insStmt.setString(2, Constants.format(event.getUei(), 256));
                insStmt.setString(3, eventHeader != null ? Constants.format(eventHeader.getDpName(), 12) : "undefined");
                int nodeid = (int)event.getNodeid();
                insStmt.setObject(4, event.hasNodeid() ? new Integer(nodeid) : null);
                insStmt.setString(5, event.getInterface());
                int svcId = -1;
                if (event.getService() != null) {
                    try {
                        svcId = this.getServiceID(event.getService());
                    }
                    catch (SQLException e) {
                        this.log().warn((Object)("insertAlarm: Error converting service name \"" + event.getService() + "\" to an integer identifier, storing -1: " + e), (Throwable)e);
                    }
                }
                insStmt.setObject(6, svcId == -1 ? null : new Integer(svcId));
                insStmt.setString(7, event.getAlarmData().getReductionKey());
                insStmt.setInt(8, event.getAlarmData().getAlarmType());
                insStmt.setInt(9, 1);
                this.set(insStmt, 10, Constants.getSeverity((String)event.getSeverity()));
                insStmt.setInt(11, event.getDbid());
                Timestamp eventTime = this.getEventTime(event);
                insStmt.setTimestamp(12, eventTime);
                insStmt.setTimestamp(13, eventTime);
                this.set(insStmt, 14, Constants.format(event.getDescr(), 4000));
                if (event.getLogmsg() != null) {
                    this.set(insStmt, 15, Constants.format(event.getLogmsg().getContent(), 256));
                } else {
                    insStmt.setNull(15, 12);
                }
                this.set(insStmt, 16, Constants.format(event.getOperinstruct(), 1024));
                if (event.getTticket() != null) {
                    this.set(insStmt, 17, Constants.format(event.getTticket().getContent(), 128));
                    int ttstate = 0;
                    if (event.getTticket().getState().equals("on")) {
                        ttstate = 1;
                    }
                    this.set(insStmt, 18, ttstate);
                } else {
                    insStmt.setNull(17, 12);
                    insStmt.setNull(18, 4);
                }
                this.set(insStmt, 19, Constants.format(event.getMouseovertext(), 64));
                this.set(insStmt, 20, eventTime);
                insStmt.setString(21, null);
                this.set(insStmt, 22, eventTime);
                insStmt.setString(23, null);
                insStmt.setTimestamp(24, null);
                if (event.getAlarmData() == null) {
                    insStmt.setString(25, null);
                    insStmt.setString(26, null);
                    insStmt.setInt(27, -1);
                    insStmt.setString(28, null);
                } else {
                    insStmt.setString(25, Constants.format(event.getAlarmData().getClearUei(), 256));
                    insStmt.setString(26, Constants.format(event.getAlarmData().getX733AlarmType(), 31));
                    this.set(insStmt, 27, event.getAlarmData().getX733ProbableCause());
                    this.set(insStmt, 28, event.getAlarmData().getClearKey());
                }
                if (event.hasIfIndex()) {
                    this.set(insStmt, 29, event.getIfIndex());
                } else {
                    insStmt.setNull(29, 4);
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("m_insStmt is: " + insStmt.toString()));
                }
                String string = parametersString = event.getParms() != null ? Parameter.format(event.getParms()) : null;
                if (parametersString != null) {
                    parametersString = parametersString.replace('\u0000', ' ');
                }
                this.set(insStmt, 30, parametersString);
                insStmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new SQLErrorCodeSQLExceptionTranslator().translate("foo", "bar", e);
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        this.updateEventForAlarm(event, alarmID, connection);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("SUCCESSFULLY added " + event.getUei() + " related  data into the ALARMS table"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAlarm(Header eventHeader, Event event, int alarmId, Connection connection) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement upDateStmt = connection.prepareStatement("UPDATE alarms    SET counter = counter+1, lastEventID = ?, lastEventTime = ?, logmsg = ?  WHERE reductionKey = ?");
            d.watch((Object)upDateStmt);
            upDateStmt.setInt(1, event.getDbid());
            upDateStmt.setTimestamp(2, this.getEventTime(event));
            this.set(upDateStmt, 3, Constants.format(event.getLogmsg().getContent(), 256));
            upDateStmt.setString(4, event.getAlarmData().getReductionKey());
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Persist.updateAlarm: reducing event " + event.getDbid() + " into alarm " + alarmId));
            }
            upDateStmt.executeUpdate();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        this.updateEventForAlarm(event, alarmId, connection);
    }

    private void updateEventForAlarm(Event event, int alarmID, Connection connection) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            try {
                PreparedStatement updateEventStmt = connection.prepareStatement("UPDATE events    SET alarmid = ?  WHERE eventid = ?");
                d.watch((Object)updateEventStmt);
                updateEventStmt.setInt(1, alarmID);
                updateEventStmt.setInt(2, event.getDbid());
                updateEventStmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log().warn((Object)("Failed to update event " + event.getDbid() + " for alarm " + alarmID + ": " + e), (Throwable)e);
                throw e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
    }

    private int isReductionNeeded(Header eventHeader, Event event, Connection connection) throws SQLException {
        try {
            int alarmId = new JdbcTemplate(this.getDataSource()).queryForInt("SELECT alarmid   FROM alarms  WHERE reductionKey = ?", new Object[]{event.getAlarmData().getReductionKey()});
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Persist.isReductionNeeded: yes for reductionKey: " + event.getAlarmData().getReductionKey()));
            }
            return alarmId;
        }
        catch (EmptyResultDataAccessException e) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Persist.isReductionNeeded: no for reductionKey: " + event.getAlarmData().getReductionKey()));
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanPreviousEvents(int alarmId, int eventId, Connection connection) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            try {
                stmt = connection.prepareStatement("DELETE FROM events WHERE alarmId = ? AND eventId != ?");
                d.watch((Object)stmt);
                stmt.setInt(1, alarmId);
                stmt.setInt(2, eventId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log().error((Object)("cleanPreviousEvents: Couldn't remove old events: " + e), (Throwable)e);
                Object var8_7 = null;
                d.cleanUp();
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
    }
}

