/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.db;

import org.opennms.netmgt.eventd.db.Constants;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public final class Parameter {
    public static String format(Parms parms) {
        boolean first = true;
        StringBuffer parmbuf = new StringBuffer();
        for (Parm parm : parms.getParmCollection()) {
            if (!first) {
                parmbuf.append(';');
            }
            parmbuf.append(Parameter.format(parm));
            first = false;
        }
        return parmbuf.toString();
    }

    public static String format(Parm parm) {
        Value pValue = parm.getValue();
        String type = pValue.getType();
        String encoding = pValue.getEncoding();
        String tmp = Constants.escape(parm.getParmName(), '=');
        String name = Constants.escape(tmp, ';');
        tmp = Constants.escape(pValue.getContent(), '=');
        String value = Constants.escape(tmp, ';');
        String empty = "";
        name = name != null ? name.trim() : empty;
        value = value != null ? value.trim() : empty;
        type = type != null ? type.trim() : empty;
        encoding = encoding != null ? encoding.trim() : empty;
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('=');
        buf.append(value);
        buf.append('(');
        buf.append(type);
        buf.append(',');
        buf.append(encoding);
        buf.append(')');
        return buf.toString();
    }

    public static Parms decode(String eventparms) {
        if (eventparms == null) {
            return null;
        }
        Parms parms = new Parms();
        String[] paramslistString = eventparms.split(Character.toString(';'));
        if (paramslistString != null) {
            for (int i = 0; i < paramslistString.length; ++i) {
                String[] paramEncoded = paramslistString[i].split(Character.toString('='));
                if (paramEncoded == null || paramEncoded.length != 2) continue;
                Parm parm = new Parm();
                parm.setParmName(paramEncoded[0]);
                Value value = new Value();
                String[] valueEncoded = paramEncoded[1].split("\\(");
                boolean isParmCorrect = false;
                if (valueEncoded != null && valueEncoded.length == 2) {
                    value.setContent(valueEncoded[0]);
                    String[] typeAndEncode = valueEncoded[1].split(Character.toString(','));
                    if (typeAndEncode != null && typeAndEncode.length == 2) {
                        value.setType(typeAndEncode[0]);
                        value.setEncoding(typeAndEncode[1].split("\\)")[0]);
                        isParmCorrect = true;
                    }
                }
                if (!isParmCorrect) continue;
                parm.setValue(value);
                parms.addParm(parm);
            }
        }
        return parms;
    }
}

