/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.db;

import java.util.Iterator;
import java.util.List;
import org.opennms.netmgt.EventConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constants
extends EventConstants {
    static final char NAME_VAL_DELIM = '=';
    static final char MULTIPLE_VAL_DELIM = ';';
    static final String ATTRIB_DELIM = "/\\";
    static final char DB_ATTRIB_DELIM = ',';
    static final String VALUE_TRUNCATE_INDICATOR = "...";

    public static String escape(String inStr, char delimchar) {
        StringBuilder buf = new StringBuilder(inStr.length() + 16);
        for (char ch : inStr.toCharArray()) {
            if (ch == delimchar || Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                buf.append('%');
                buf.append(String.valueOf((int)ch));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String format(List<String> strings, int maxlen) {
        if (strings == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator<String> i = strings.iterator();
        while (i.hasNext() && buf.length() < maxlen) {
            String s = i.next();
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String[] strings, int maxlen) {
        if (strings == null || strings.length <= 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (int index = 0; index < strings.length && buf.length() < maxlen; ++index) {
            String s = strings[index];
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String origString, int maxlen) {
        if (origString == null) {
            return null;
        }
        String escapedString = Constants.escape(origString, '\u0000');
        if (escapedString.length() >= maxlen) {
            StringBuffer buf = new StringBuffer(escapedString);
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
            return buf.toString();
        }
        return escapedString;
    }
}

