/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UdpReceiver
implements Runnable {
    private List<UdpReceivedEvent> m_eventsIn;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context;
    private String m_logPrefix;

    UdpReceiver(DatagramSocket sock, List<UdpReceivedEvent> xchange) {
        this.m_eventsIn = xchange;
        this.m_stop = false;
        this.m_dgSock = sock;
        this.m_logPrefix = "OpenNMS.Eventd";
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Stopping and joining thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            this.log().debug((Object)"Thread context stopped and joined");
        }
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            this.log().debug((Object)"Stop flag set before thread started, exiting");
            return;
        }
        this.log().debug((Object)"Thread context started");
        int length = 65535;
        byte[] buffer = new byte[65535];
        DatagramPacket pkt = new DatagramPacket(buffer, 65535);
        try {
            this.log().debug((Object)"Setting socket timeout to 500ms");
            this.m_dgSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            this.log().warn((Object)("An I/O error occured while trying to set the socket timeout: " + e), (Throwable)e);
        }
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Setting receive buffer size to 65535");
            }
            this.m_dgSock.setReceiveBufferSize(65535);
        }
        catch (SocketException e) {
            this.log().info((Object)("Failed to set the receive buffer to 65535: " + e), (Throwable)e);
        }
        boolean ioInterrupted = false;
        while (!this.m_stop) {
            if (this.m_context.isInterrupted()) {
                this.log().debug((Object)"Thread context interrupted");
                break;
            }
            try {
                if (this.log().isDebugEnabled() && !ioInterrupted) {
                    this.log().debug((Object)"Wating on a datagram to arrive");
                }
                this.m_dgSock.receive(pkt);
                ioInterrupted = false;
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
                continue;
            }
            catch (IOException e) {
                this.log().error((Object)("An I/O exception occured on the datagram receipt port, exiting: " + e), (Throwable)e);
                break;
            }
            try {
                this.log().debug((Object)"Sending received packet to processor");
                UdpReceivedEvent re = UdpReceivedEvent.make(pkt);
                List<UdpReceivedEvent> list = this.m_eventsIn;
                synchronized (list) {
                    this.m_eventsIn.add(re);
                    this.m_eventsIn.notify();
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log().warn((Object)("Failed to convert received XML event, discarding: " + e), (Throwable)e);
            }
            pkt = new DatagramPacket(buffer, 65535);
        }
        this.log().debug((Object)"Thread context exiting");
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

