/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.EventHandlerMBeanProxy;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpEventReceiverMBean;
import org.opennms.netmgt.eventd.adaptors.udp.UdpProcessor;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpUuidSender;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UdpEventReceiver
implements EventReceiver,
UdpEventReceiverMBean {
    private static final int UDP_PORT = 5817;
    private UdpReceiver m_receiver;
    private UdpProcessor m_processor;
    private UdpUuidSender m_output;
    private List<UdpReceivedEvent> m_eventsIn;
    private List<UdpReceivedEvent> m_eventUuidsOut;
    private List<EventHandler> m_eventHandlers;
    private volatile int m_status;
    private DatagramSocket m_dgSock = null;
    private String m_ipAddress;
    private int m_dgPort;
    private String m_logPrefix;

    public UdpEventReceiver() {
        this(5817, null);
    }

    public UdpEventReceiver(int port, String ipAddress) {
        this.m_ipAddress = ipAddress;
        this.m_dgPort = port;
        this.m_eventsIn = new LinkedList<UdpReceivedEvent>();
        this.m_eventUuidsOut = new LinkedList<UdpReceivedEvent>();
        this.m_eventHandlers = new ArrayList<EventHandler>(3);
        this.m_status = 0;
        this.m_dgSock = null;
        this.m_receiver = null;
        this.m_processor = null;
        this.m_output = null;
        this.m_logPrefix = null;
    }

    @Override
    public synchronized void start() {
        this.assertNotRunning();
        this.m_status = 1;
        try {
            InetAddress address = "*".equals(this.m_ipAddress) ? null : InetAddress.getByName(this.m_ipAddress);
            this.m_dgSock = new DatagramSocket(this.m_dgPort, address);
            this.m_receiver = new UdpReceiver(this.m_dgSock, this.m_eventsIn);
            this.m_processor = new UdpProcessor(this.m_eventHandlers, this.m_eventsIn, this.m_eventUuidsOut);
            this.m_output = new UdpUuidSender(this.m_dgSock, this.m_eventUuidsOut, this.m_eventHandlers);
            if (this.m_logPrefix != null) {
                this.m_receiver.setLogPrefix(this.m_logPrefix);
                this.m_processor.setLogPrefix(this.m_logPrefix);
                this.m_output.setLogPrefix(this.m_logPrefix);
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        Thread rThread = new Thread((Runnable)this.m_receiver, "UDP Event Receiver[" + this.m_dgPort + "]");
        Thread pThread = new Thread((Runnable)this.m_processor, "UDP Event Processor[" + this.m_dgPort + "]");
        Thread oThread = new Thread((Runnable)this.m_output, "UDP UUID Sender[" + this.m_dgPort + "]");
        try {
            rThread.start();
            pThread.start();
            oThread.start();
        }
        catch (RuntimeException e) {
            rThread.interrupt();
            pThread.interrupt();
            oThread.interrupt();
            this.m_status = 4;
            throw e;
        }
        this.m_status = 2;
    }

    @Override
    public synchronized void stop() {
        if (this.m_status == 4) {
            return;
        }
        if (this.m_status == 0) {
            this.m_status = 4;
            return;
        }
        this.m_status = 3;
        try {
            this.m_receiver.stop();
            this.m_processor.stop();
            this.m_output.stop();
        }
        catch (InterruptedException e) {
            this.log().warn((Object)("The thread was interrupted while attempting to join sub-threads: " + e), (Throwable)e);
        }
        this.m_dgSock.close();
        this.m_status = 4;
    }

    public String getName() {
        return "Event UDP Receiver[" + this.m_dgPort + "]";
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.assertNotRunning();
        this.m_ipAddress = ipAddress;
    }

    @Override
    public void setPort(Integer port) {
        this.assertNotRunning();
        this.m_dgPort = port;
    }

    @Override
    public Integer getPort() {
        return new Integer(this.m_dgPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventHandler(EventHandler handler) {
        List<EventHandler> list = this.m_eventHandlers;
        synchronized (list) {
            if (!this.m_eventHandlers.contains(handler)) {
                this.m_eventHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventHandler(EventHandler handler) {
        List<EventHandler> list = this.m_eventHandlers;
        synchronized (list) {
            this.m_eventHandlers.remove(handler);
        }
    }

    public List<EventHandler> getEventHandlers() {
        return this.m_eventHandlers;
    }

    public void setEventHandlers(List<EventHandler> eventHandlers) {
        this.m_eventHandlers = eventHandlers;
    }

    @Override
    public void addEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.addEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    @Override
    public void removeEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.removeEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    @Override
    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private void assertNotRunning() {
        Assert.state((this.m_status == 0 || this.m_status == 4 ? 1 : 0) != 0, (String)"The fiber is already running and cannot be modified or started");
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

