/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.Collection;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.BroadcastEventProcessor;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Eventd
extends AbstractServiceDaemon {
    public static final String LOG4J_CATEGORY = "OpenNMS.Eventd";
    private BroadcastEventProcessor m_receiver;
    private EventdServiceManager m_eventdServiceManager;
    private Collection<EventReceiver> m_eventReceivers;

    public Eventd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        Assert.state((this.m_eventdServiceManager != null ? 1 : 0) != 0, (String)"property eventdServiceManager must be set");
        Assert.state((this.m_eventReceivers != null ? 1 : 0) != 0, (String)"property eventReceivers must be set");
        Assert.state((this.m_receiver != null ? 1 : 0) != 0, (String)"property receiver must be set");
        this.m_eventdServiceManager.dataSourceSync();
    }

    protected void onStart() {
        for (EventReceiver eventReceiver : this.m_eventReceivers) {
            eventReceiver.start();
        }
        this.log().debug((Object)"Listener threads started");
        this.log().debug((Object)"Eventd running");
    }

    protected void onStop() {
        this.log().debug((Object)"calling shutdown on tcp/udp listener threads");
        for (EventReceiver eventReceiver : this.m_eventReceivers) {
            eventReceiver.stop();
        }
        if (this.m_receiver != null) {
            this.m_receiver.close();
        }
        this.log().debug((Object)"shutdown on tcp/udp listener threads returned");
    }

    public EventdServiceManager getEventdServiceManager() {
        return this.m_eventdServiceManager;
    }

    public void setEventdServiceManager(EventdServiceManager eventdServiceManager) {
        this.m_eventdServiceManager = eventdServiceManager;
    }

    public BroadcastEventProcessor getReceiver() {
        return this.m_receiver;
    }

    public void setReceiver(BroadcastEventProcessor receiver) {
        this.m_receiver = receiver;
    }

    public Collection<EventReceiver> getEventReceivers() {
        return this.m_eventReceivers;
    }

    public void setEventReceivers(Collection<EventReceiver> eventReceivers) {
        this.m_eventReceivers = eventReceivers;
    }
}

