/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.opennms.netmgt.config.TimeInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeIntervalSequence {
    private TimeInterval m_interval;
    private TimeIntervalSequence m_tail;

    public TimeIntervalSequence() {
        this(null, null);
    }

    public TimeIntervalSequence(TimeInterval interval) {
        this(interval, null);
    }

    private TimeIntervalSequence(TimeInterval interval, TimeIntervalSequence tail) {
        this.m_interval = interval;
        this.m_tail = tail;
    }

    public Iterator<? extends TimeInterval> iterator() {
        return new TimeIntervalSeqIter(this);
    }

    Date min(Date a, Date b) {
        return a.before(b) ? a : b;
    }

    Date max(Date a, Date b) {
        return b.before(a) ? a : b;
    }

    public void addInterval(TimeInterval interval) {
        if (this.m_interval == null) {
            this.m_interval = interval;
        } else if (this.m_interval.preceeds(interval)) {
            this.addPreceedingInterval(interval);
        } else if (this.m_interval.follows(interval)) {
            this.addSucceedingInterval(interval);
        } else if (this.m_interval.overlaps(interval)) {
            this.addOverlappingInterval(interval);
        }
    }

    private void addOverlappingInterval(TimeInterval newInterval) {
        Collection<? extends TimeInterval> newIntervals = this.combineIntervals(this.m_interval, newInterval);
        this.removeCurrent();
        this.addAll(newIntervals);
    }

    protected Collection<? extends TimeInterval> combineIntervals(TimeInterval currentInterval, TimeInterval newInterval) {
        ArrayList<TimeInterval> newIntervals = new ArrayList<TimeInterval>(3);
        Date first = this.min(currentInterval.getStart(), newInterval.getStart());
        Date second = this.max(currentInterval.getStart(), newInterval.getStart());
        Date third = this.min(currentInterval.getEnd(), newInterval.getEnd());
        Date fourth = this.max(currentInterval.getEnd(), newInterval.getEnd());
        if (first.equals(second)) {
            newIntervals.add(this.createInterval(first, third));
        } else {
            newIntervals.add(this.createInterval(first, second));
            newIntervals.add(this.createInterval(second, third));
        }
        if (!third.equals(fourth)) {
            newIntervals.add(this.createInterval(third, fourth));
        }
        return newIntervals;
    }

    private void addSucceedingInterval(TimeInterval interval) {
        TimeIntervalSequence oldTail = this.m_tail;
        this.m_tail = this.createTail(this.m_interval);
        this.m_tail.m_tail = oldTail;
        this.m_interval = interval;
    }

    private void addPreceedingInterval(TimeInterval interval) {
        this.addToTail(interval);
    }

    private void addToTail(TimeInterval interval) {
        if (this.m_tail == null) {
            this.m_tail = this.createTail(interval);
        } else {
            this.m_tail.addInterval(interval);
        }
    }

    protected TimeInterval createInterval(Date start, Date end) {
        return new TimeInterval(start, end);
    }

    protected TimeIntervalSequence createTail(TimeInterval interval) {
        return new TimeIntervalSequence(interval);
    }

    private void removeCurrent() {
        if (this.m_tail == null) {
            this.m_interval = null;
        } else {
            this.m_interval = this.m_tail.m_interval;
            this.m_tail = this.m_tail.m_tail;
        }
    }

    public void removeInterval(TimeInterval removedInterval) {
        if (this.m_interval == null) {
            return;
        }
        if (this.m_interval.preceeds(removedInterval)) {
            this.removeFromTail(removedInterval);
        } else {
            if (this.m_interval.follows(removedInterval)) {
                return;
            }
            if (this.m_interval.overlaps(removedInterval)) {
                TimeInterval origInterval = this.m_interval;
                this.removeFromTail(removedInterval);
                this.removeCurrent();
                Collection<? extends TimeInterval> newIntervals = this.separateIntervals(origInterval, removedInterval);
                this.addAll(newIntervals);
            }
        }
    }

    protected Collection<? extends TimeInterval> separateIntervals(TimeInterval origInterval, TimeInterval removedInterval) {
        ArrayList<TimeInterval> newIntervals = new ArrayList<TimeInterval>(2);
        if (removedInterval.getEnd().before(origInterval.getEnd())) {
            newIntervals.add(this.createInterval(removedInterval.getEnd(), origInterval.getEnd()));
        }
        if (origInterval.getStart().before(removedInterval.getStart())) {
            newIntervals.add(this.createInterval(origInterval.getStart(), removedInterval.getStart()));
        }
        return newIntervals;
    }

    private void removeFromTail(TimeInterval interval) {
        if (this.m_tail == null) {
            return;
        }
        this.m_tail.removeInterval(interval);
        if (this.m_tail.m_interval == null) {
            this.m_tail = null;
        }
    }

    public void bound(Date start, Date end) {
        this.removeInterval(this.createInterval(new Date(0L), start));
        this.removeInterval(this.createInterval(end, new Date(Long.MAX_VALUE)));
    }

    public void bound(TimeInterval interval) {
        this.bound(interval.getStart(), interval.getEnd());
    }

    public Date getStart() {
        if (this.m_interval == null) {
            return null;
        }
        return this.m_interval.getStart();
    }

    public Date getEnd() {
        if (this.m_interval == null) {
            return null;
        }
        if (this.m_tail == null) {
            return this.m_interval.getEnd();
        }
        return this.m_tail.getEnd();
    }

    public TimeInterval getBounds() {
        Date start = this.getStart();
        Date end = this.getEnd();
        return start == null || end == null ? null : new TimeInterval(start, end);
    }

    public void addAll(TimeIntervalSequence intervals) {
        Iterator<? extends TimeInterval> it = intervals.iterator();
        while (it.hasNext()) {
            TimeInterval interval = it.next();
            this.addInterval(interval);
        }
    }

    public void addAll(Collection<? extends TimeInterval> intervals) {
        for (TimeInterval timeInterval : intervals) {
            this.addInterval(timeInterval);
        }
    }

    public void removeAll(TimeIntervalSequence intervals) {
        Iterator<? extends TimeInterval> it = intervals.iterator();
        while (it.hasNext()) {
            TimeInterval interval = it.next();
            this.removeInterval(interval);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        boolean first = true;
        Iterator<? extends TimeInterval> it = this.iterator();
        while (it.hasNext()) {
            TimeInterval interval = it.next();
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(interval);
        }
        buf.append(']');
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeIntervalSeqIter
    implements Iterator<TimeInterval> {
        private TimeIntervalSequence m_current;

        public TimeIntervalSeqIter(TimeIntervalSequence seq) {
            this.m_current = seq;
        }

        @Override
        public boolean hasNext() {
            return this.m_current != null && this.m_current.m_interval != null;
        }

        @Override
        public TimeInterval next() {
            TimeInterval interval = this.m_current.m_interval;
            this.m_current = this.m_current.m_tail;
            return interval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not implemented yet");
        }
    }
}

