/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.siteStatusViews.SiteStatusViewConfiguration;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.dao.castor.CastorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteStatusViewsFactory {
    private static SiteStatusViewsFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    protected static Map<String, View> m_viewsMap;
    private static SiteStatusViewConfiguration m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SiteStatusViewsFactory(String configFile) throws MarshalException, ValidationException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.initialize(stream);
            Object var4_3 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (stream == null) throw throwable;
            IOUtils.closeQuietly((InputStream)stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public SiteStatusViewsFactory(InputStream stream) throws MarshalException, ValidationException {
        this.initialize(stream);
    }

    @Deprecated
    public SiteStatusViewsFactory(Reader rdr) throws MarshalException, ValidationException {
        this.initialize(rdr);
    }

    @Deprecated
    private void initialize(Reader rdr) throws MarshalException, ValidationException {
        this.log().debug((Object)"initialize: initializing site status views factory.");
        m_config = (SiteStatusViewConfiguration)CastorUtils.unmarshal(SiteStatusViewConfiguration.class, (Reader)rdr);
        this.initializeViewsMap();
    }

    private void initialize(InputStream stream) throws MarshalException, ValidationException {
        this.log().debug((Object)"initialize: initializing site status views factory.");
        m_config = (SiteStatusViewConfiguration)CastorUtils.unmarshal(SiteStatusViewConfiguration.class, (InputStream)stream);
        this.initializeViewsMap();
    }

    private void initializeViewsMap() {
        m_viewsMap = new HashMap<String, View>();
        for (View view : m_config.getViews().getViewCollection()) {
            m_viewsMap.put(view.getName(), view);
        }
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SITE_STATUS_VIEWS_FILE_NAME);
            m_instance = new SiteStatusViewsFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized SiteStatusViewsFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call ViewDisplay.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(SiteStatusViewsFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        SiteStatusViewsFactory.init();
    }

    public View getView(String viewName) throws IOException, MarshalException, ValidationException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.updateFromFile();
        View view = m_viewsMap.get(viewName);
        return view;
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        File siteStatusViewsFile;
        if (m_loadedFromFile && m_lastModified != (siteStatusViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SITE_STATUS_VIEWS_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized SiteStatusViewConfiguration getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(SiteStatusViewConfiguration m_config) {
        SiteStatusViewsFactory.m_config = m_config;
    }

    public static synchronized Map<String, View> getViewsMap() {
        return m_viewsMap;
    }

    public static synchronized void setViewsMap(Map<String, View> map) {
        m_viewsMap = map;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    static {
        m_loadedFromFile = false;
    }
}

