/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotificationManager;

public class NotificationFactory
extends NotificationManager {
    private static NotificationFactory instance;
    protected File m_notifConfFile;
    private static boolean initialized;
    private File m_noticeConfFile;
    private long m_lastModified;

    private NotificationFactory() {
        super(NotifdConfigFactory.getInstance(), DataSourceFactory.getInstance());
    }

    public static synchronized NotificationFactory getInstance() {
        if (!initialized) {
            return null;
        }
        return instance;
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException, ClassNotFoundException, SQLException, PropertyVetoException {
        if (!initialized) {
            DataSourceFactory.init();
            instance = new NotificationFactory();
            instance.reload();
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reload() throws IOException, MarshalException, ValidationException {
        this.m_noticeConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NOTIFICATIONS_CONF_FILE_NAME);
        FileInputStream configIn = null;
        try {
            configIn = new FileInputStream(this.m_noticeConfFile);
            this.m_lastModified = this.m_noticeConfFile.lastModified();
            this.parseXML(configIn);
            Object var3_2 = null;
            if (configIn == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (configIn == null) throw throwable;
            IOUtils.closeQuietly((InputStream)configIn);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configIn);
    }

    protected void saveXML(String xmlString) throws IOException {
        if (xmlString != null) {
            FileWriter fileWriter = new FileWriter(this.m_noticeConfFile);
            fileWriter.write(xmlString);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public void update() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_noticeConfFile.lastModified()) {
            this.reload();
        }
    }

    static {
        initialized = false;
    }
}

