/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.PeerFactory;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.config.nsclient.Definition;
import org.opennms.netmgt.config.nsclient.NsclientConfig;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.poller.nsclient.NSClientAgentConfig;
import org.opennms.protocols.ip.IPv4Address;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class NSClientPeerFactory
extends PeerFactory {
    private static NSClientPeerFactory m_singleton = null;
    private static NsclientConfig m_config;
    private static boolean m_loaded;

    private NSClientPeerFactory(String configFile) throws IOException, MarshalException, ValidationException {
        m_config = (NsclientConfig)CastorUtils.unmarshal(NsclientConfig.class, (Resource)new FileSystemResource(configFile));
    }

    public NSClientPeerFactory(InputStream stream) throws IOException, MarshalException, ValidationException {
        m_config = (NsclientConfig)CastorUtils.unmarshal(NsclientConfig.class, (InputStream)stream);
    }

    @Deprecated
    public NSClientPeerFactory(Reader rdr) throws IOException, MarshalException, ValidationException {
        m_config = (NsclientConfig)CastorUtils.unmarshal(NsclientConfig.class, (Reader)rdr);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_CONFIG_FILE_NAME);
        NSClientPeerFactory.log().debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new NSClientPeerFactory(cfgFile.getPath());
        m_loaded = true;
    }

    private static Category log() {
        return ThreadCategory.getInstance(NSClientPeerFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        NSClientPeerFactory.init();
    }

    public static synchronized void saveCurrent() throws Exception {
        NSClientPeerFactory.optimize();
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            FileWriter fileWriter = new FileWriter(ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_CONFIG_FILE_NAME));
            fileWriter.write(stringWriter.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        NSClientPeerFactory.reload();
    }

    private static void optimize() throws UnknownHostException {
        Category log = NSClientPeerFactory.log();
        Iterator definitionsIterator = m_config.getDefinitionCollection().iterator();
        while (definitionsIterator.hasNext()) {
            Definition definition = (Definition)definitionsIterator.next();
            if (definition.getSpecificCount() != 0 || definition.getRangeCount() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"optimize: Removing empty definition element");
            }
            definitionsIterator.remove();
        }
        for (Definition definition : m_config.getDefinitionCollection()) {
            Iterator rangesIterator = definition.getRangeCollection().iterator();
            while (rangesIterator.hasNext()) {
                Range range = (Range)rangesIterator.next();
                if (!range.getBegin().equals(range.getEnd())) continue;
                definition.addSpecific(range.getBegin());
                rangesIterator.remove();
            }
        }
        for (Definition definition : m_config.getDefinitionCollection()) {
            int specificInt;
            TreeMap<Integer, String> specificsMap = new TreeMap<Integer, String>();
            for (String specific : definition.getSpecificCollection()) {
                specificsMap.put(new Integer(new IPv4Address(specific).getAddress()), specific.trim());
            }
            TreeMap<Integer, Range> rangesMap = new TreeMap<Integer, Range>();
            for (Range range : definition.getRangeCollection()) {
                rangesMap.put(new Integer(new IPv4Address(range.getBegin()).getAddress()), range);
            }
            Integer priorSpecific = null;
            Range addedRange = null;
            for (Integer specific : specificsMap.keySet()) {
                int priorSpecificInt;
                if (priorSpecific == null) {
                    priorSpecific = specific;
                    continue;
                }
                specificInt = specific;
                if (specificInt == (priorSpecificInt = priorSpecific.intValue()) + 1) {
                    if (addedRange == null) {
                        addedRange = new Range();
                        addedRange.setBegin(IPv4Address.addressToString((int)priorSpecificInt));
                        rangesMap.put(priorSpecific, addedRange);
                        specificsMap.remove(priorSpecific);
                    }
                    addedRange.setEnd(IPv4Address.addressToString((int)specificInt));
                    specificsMap.remove(specific);
                } else {
                    addedRange = null;
                }
                priorSpecific = specific;
            }
            block7: for (Integer specific : specificsMap.keySet()) {
                specificInt = specific;
                for (Integer begin : rangesMap.keySet()) {
                    Range range;
                    int endInt;
                    int beginInt = begin;
                    if (specificInt < beginInt - 1 || specificInt > (endInt = new IPv4Address((range = (Range)rangesMap.get(begin)).getEnd()).getAddress()) + 1) continue;
                    if (specificInt >= beginInt && specificInt <= endInt) {
                        specificsMap.remove(specific);
                        continue block7;
                    }
                    if (specificInt == beginInt - 1) {
                        rangesMap.remove(begin);
                        rangesMap.put(specific, range);
                        range.setBegin(IPv4Address.addressToString((int)specificInt));
                        specificsMap.remove(specific);
                        continue block7;
                    }
                    if (specificInt != endInt + 1) continue;
                    range.setEnd(IPv4Address.addressToString((int)specificInt));
                    specificsMap.remove(specific);
                    continue block7;
                }
            }
            Range priorRange = null;
            int priorBegin = 0;
            int priorEnd = 0;
            Iterator rangesIterator = rangesMap.keySet().iterator();
            while (rangesIterator.hasNext()) {
                Integer rangeKey = (Integer)rangesIterator.next();
                Range range = (Range)rangesMap.get(rangeKey);
                int begin = rangeKey;
                int end = new IPv4Address(range.getEnd()).getAddress();
                if (priorRange != null && begin - priorEnd <= 1) {
                    priorRange.setBegin(IPv4Address.addressToString((int)Math.min(priorBegin, begin)));
                    priorRange.setEnd(IPv4Address.addressToString((int)Math.max(priorEnd, end)));
                    rangesIterator.remove();
                    continue;
                }
                priorRange = range;
                priorBegin = begin;
                priorEnd = end;
            }
            definition.setSpecific(new ArrayList(specificsMap.values()));
            definition.setRange(new ArrayList(rangesMap.values()));
        }
    }

    public static synchronized NSClientPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The NSClientPeerFactory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(NSClientPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public void define(InetAddress ip, String password) throws UnknownHostException {
        Category log = NSClientPeerFactory.log();
        int address = new IPv4Address(ip).getAddress();
        ArrayList<Definition> definitions = new ArrayList<Definition>(m_config.getDefinitionCollection());
        Definition definition = null;
        for (Definition currentDefinition : definitions) {
            if ((currentDefinition.getPassword() == null || !currentDefinition.getPassword().equals(password)) && (currentDefinition.getPassword() != null || m_config.getPassword() == null || !m_config.getPassword().equals(password))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("define: Found existing definition with read-community " + password));
            }
            definition = currentDefinition;
            break;
        }
        if (definition == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"define: Creating new definition");
            }
            definition = new Definition();
            definition.setPassword(password);
            definitions.add(definition);
        }
        definition.addSpecific(ip.getHostAddress());
        for (Definition currentDefinition : definitions) {
            Range[] rangesArray;
            if (currentDefinition == definition) continue;
            while (currentDefinition.removeSpecific(ip.getHostAddress())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("define: Removed an existing specific element with IP " + ip));
            }
            ArrayList<Range> ranges = new ArrayList<Range>(currentDefinition.getRangeCollection());
            for (Range range : rangesArray = currentDefinition.getRange()) {
                int begin = new IPv4Address(range.getBegin()).getAddress();
                int end = new IPv4Address(range.getEnd()).getAddress();
                if (address < begin || address > end) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("define: Splitting range element with begin " + range.getBegin() + " and " + "end " + range.getEnd()));
                }
                if (begin == end) {
                    ranges.remove(range);
                    continue;
                }
                if (address == begin) {
                    range.setBegin(IPv4Address.addressToString((int)(address + 1)));
                    continue;
                }
                if (address == end) {
                    range.setEnd(IPv4Address.addressToString((int)(address - 1)));
                    continue;
                }
                Range head = new Range();
                head.setBegin(range.getBegin());
                head.setEnd(IPv4Address.addressToString((int)(address - 1)));
                Range tail = new Range();
                tail.setBegin(IPv4Address.addressToString((int)(address + 1)));
                tail.setEnd(range.getEnd());
                ranges.remove(range);
                ranges.add(head);
                ranges.add(tail);
            }
            currentDefinition.setRange(ranges);
        }
        m_config.setDefinition(definitions);
    }

    public synchronized NSClientAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        if (m_config == null) {
            NSClientAgentConfig agentConfig = new NSClientAgentConfig(agentInetAddress);
            return agentConfig;
        }
        NSClientAgentConfig agentConfig = new NSClientAgentConfig(agentInetAddress);
        this.setNSClientAgentConfig(agentConfig, new Definition());
        block4: for (Definition def : m_config.getDefinitionCollection()) {
            for (String saddr : def.getSpecificCollection()) {
                try {
                    InetAddress addr = InetAddress.getByName(saddr);
                    if (!addr.equals(agentConfig.getAddress())) continue;
                    this.setNSClientAgentConfig(agentConfig, def);
                    break block4;
                }
                catch (UnknownHostException e) {
                    Logger log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
                    log.warn((Object)("NSClientPeerFactory: could not convert host " + saddr + " to InetAddress"), (Throwable)e);
                }
            }
            long lhost = InetAddressUtils.toIpAddrLong((InetAddress)agentConfig.getAddress());
            for (Range rng : def.getRangeCollection()) {
                try {
                    InetAddress begin = InetAddress.getByName(rng.getBegin());
                    InetAddress end = InetAddress.getByName(rng.getEnd());
                    long start = InetAddressUtils.toIpAddrLong((InetAddress)begin);
                    long stop = InetAddressUtils.toIpAddrLong((InetAddress)end);
                    if (start > lhost || lhost > stop) continue;
                    this.setNSClientAgentConfig(agentConfig, def);
                    break block4;
                }
                catch (UnknownHostException e) {
                    Logger log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
                    log.warn((Object)("NSClientPeerFactory: could not convert host(s) " + rng.getBegin() + " - " + rng.getEnd() + " to InetAddress"), (Throwable)e);
                }
            }
            for (String ipMatch : def.getIpMatchCollection()) {
                if (!IPLike.matches((String)agentInetAddress.getHostAddress(), (String)ipMatch)) continue;
                this.setNSClientAgentConfig(agentConfig, def);
                break block4;
            }
        }
        if (agentConfig == null) {
            Definition def = new Definition();
            this.setNSClientAgentConfig(agentConfig, def);
        }
        return agentConfig;
    }

    private void setNSClientAgentConfig(NSClientAgentConfig agentConfig, Definition def) {
        this.setCommonAttributes(agentConfig, def);
        agentConfig.setPassword(this.determinePassword(def));
    }

    private void setCommonAttributes(NSClientAgentConfig agentConfig, Definition def) {
        agentConfig.setPort(this.determinePort(def));
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
    }

    private String determinePassword(Definition def) {
        return def.getPassword() == null ? (m_config.getPassword() == null ? "None" : m_config.getPassword()) : def.getPassword();
    }

    private int determinePort(Definition def) {
        int port = 161;
        return def.getPort() == 0 ? (m_config.getPort() == 0 ? port : m_config.getPort()) : def.getPort();
    }

    private long determineTimeout(Definition def) {
        long timeout = 3000L;
        return def.getTimeout() == 0 ? (m_config.getTimeout() == 0 ? timeout : (long)m_config.getTimeout()) : (long)def.getTimeout();
    }

    private int determineRetries(Definition def) {
        int retries = 1;
        return def.getRetry() == 0 ? (m_config.getRetry() == 0 ? retries : m_config.getRetry()) : def.getRetry();
    }

    public static NsclientConfig getNSClientConfig() {
        return m_config;
    }

    public static synchronized void setNSClientConfig(NsclientConfig m_config) {
        NSClientPeerFactory.m_config = m_config;
    }

    static {
        m_loaded = false;
    }
}

