/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.ExcludeRange;
import org.opennms.netmgt.config.linkd.IncludeRange;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.config.linkd.Vendor;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.protocols.snmp.SnmpObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinkdConfigManager
implements LinkdConfig {
    protected static LinkdConfiguration m_config;
    private static Map<String, List<String>> m_urlIPMap;
    private static Map<Package, List<String>> m_pkgIpMap;
    private static HashMap<String, String> m_oidMask2className;

    @Deprecated
    public LinkdConfigManager(Reader reader) throws MarshalException, ValidationException, IOException {
        this.reloadXML(reader);
    }

    public LinkdConfigManager(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
    }

    @Override
    public abstract void update() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXml(String var1) throws IOException;

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public synchronized Package getPackage(String name) {
        for (Package thisPackage : m_config.getPackageCollection()) {
            if (!thisPackage.getName().equals(name)) continue;
            return thisPackage;
        }
        return null;
    }

    private void createUrlIpMap() {
        m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : m_config.getPackageCollection()) {
            for (String urlname : pkg.getIncludeUrlCollection()) {
                List iplist = IpListFromUrl.parse((String)urlname);
                if (iplist.size() <= 0) continue;
                m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    @Override
    public void createPackageIpListMap() {
        m_pkgIpMap = new HashMap<Package, List<String>>();
        for (Package pkg : m_config.getPackageCollection()) {
            try {
                List<String> ipList = this.getIpList(pkg);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("createPackageIpMap: package " + pkg.getName() + ": ipList size =  " + ipList.size()));
                }
                if (ipList.size() <= 0) continue;
                m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                this.log().error((Object)("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List: " + t), t);
            }
        }
    }

    @Override
    public List<String> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules.toString()));
        }
        List ipList = FilterDaoFactory.getInstance().getIPList(filterRules.toString());
        return ipList;
    }

    @Override
    public boolean useIpRouteDiscovery() {
        boolean discoveryUsingRoutes = true;
        if (m_config.hasUseIpRouteDiscovery()) {
            discoveryUsingRoutes = m_config.getUseIpRouteDiscovery();
        }
        return discoveryUsingRoutes;
    }

    @Override
    public boolean saveRouteTable() {
        boolean downloadRoutes = true;
        if (m_config.hasSaveRouteTable()) {
            downloadRoutes = m_config.getSaveRouteTable();
        }
        return downloadRoutes;
    }

    @Override
    public boolean useCdpDiscovery() {
        boolean discoveryUsingCdp = true;
        if (m_config.hasUseCdpDiscovery()) {
            discoveryUsingCdp = m_config.getUseCdpDiscovery();
        }
        return discoveryUsingCdp;
    }

    @Override
    public boolean useBridgeDiscovery() {
        boolean discoveryUsingBridge = true;
        if (m_config.hasUseBridgeDiscovery()) {
            discoveryUsingBridge = m_config.getUseBridgeDiscovery();
        }
        return discoveryUsingBridge;
    }

    @Override
    public boolean saveStpNodeTable() {
        boolean download = true;
        if (m_config.hasSaveStpNodeTable()) {
            download = m_config.getSaveStpNodeTable();
        }
        return download;
    }

    @Override
    public boolean enableDiscoveryDownload() {
        boolean enable = false;
        if (m_config.hasEnableDiscoveryDownload()) {
            enable = m_config.getEnableDiscoveryDownload();
        }
        return enable;
    }

    @Override
    public boolean saveStpInterfaceTable() {
        boolean download = true;
        if (m_config.hasSaveStpInterfaceTable()) {
            download = m_config.getSaveStpInterfaceTable();
        }
        return download;
    }

    @Override
    public long getInitialSleepTime() {
        long initialSleepTime = 1800000L;
        if (m_config.hasInitial_sleep_time()) {
            initialSleepTime = m_config.getInitial_sleep_time();
        }
        return initialSleepTime;
    }

    @Override
    public long getSnmpPollInterval() {
        long snmppollinterval = 900000L;
        if (m_config.hasSnmp_poll_interval()) {
            snmppollinterval = m_config.getSnmp_poll_interval();
        }
        return snmppollinterval;
    }

    @Override
    public long getDiscoveryLinkInterval() {
        long discoverylinkinterval = 3600000L;
        if (m_config.hasSnmp_poll_interval()) {
            discoverylinkinterval = m_config.getDiscovery_link_interval();
        }
        return discoverylinkinterval;
    }

    @Override
    public int getThreads() {
        int threads = 5;
        if (m_config.hasThreads()) {
            threads = m_config.getThreads();
        }
        return threads;
    }

    @Override
    public synchronized LinkdConfiguration getConfiguration() {
        return m_config;
    }

    @Override
    public boolean autoDiscovery() {
        boolean autodiscovery = false;
        if (m_config.hasAutoDiscovery()) {
            autodiscovery = m_config.getAutoDiscovery();
        }
        return autodiscovery;
    }

    @Override
    public boolean enableVlanDiscovery() {
        boolean vlandiscovery = true;
        if (m_config.hasEnableVlanDiscovery()) {
            vlandiscovery = m_config.getEnableVlanDiscovery();
        }
        return vlandiscovery;
    }

    private void getClassNames() throws IOException, MarshalException, ValidationException {
        m_oidMask2className = new HashMap();
        ArrayList<String> excludedOids = new ArrayList<String>();
        Vendor[] vendors = m_config.getVlans().getVendor();
        for (int i = 0; i < vendors.length; ++i) {
            SnmpObjectId curRootSysOid = new SnmpObjectId(vendors[i].getSysoidRootMask());
            String curClassName = vendors[i].getClassName();
            String[] specifics = vendors[i].getSpecific();
            for (int js = 0; js < specifics.length; ++js) {
                SnmpObjectId oidMask = new SnmpObjectId(specifics[js]);
                oidMask.prepend(curRootSysOid);
                m_oidMask2className.put(oidMask.toString(), curClassName);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("getClassNames:  adding class " + curClassName + " for oid " + oidMask.toString()));
            }
            ExcludeRange[] excludeds = vendors[i].getExcludeRange();
            for (int je = 0; je < excludeds.length; ++je) {
                SnmpObjectId snmpBeginOid = new SnmpObjectId(excludeds[je].getBegin());
                SnmpObjectId snmpEndOid = new SnmpObjectId(excludeds[je].getEnd());
                SnmpObjectId snmpRootOid = this.getRootOid(snmpBeginOid);
                if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !snmpRootOid.isRootOf(snmpEndOid)) continue;
                SnmpObjectId snmpCurOid = new SnmpObjectId(snmpBeginOid);
                while (snmpCurOid.compare(snmpEndOid) <= 0) {
                    excludedOids.add(snmpCurOid.toString());
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("getClassNames:  signing excluded class " + curClassName + " for oid " + curRootSysOid.toString().concat(snmpCurOid.toString())));
                    }
                    int lastCurCipher = snmpCurOid.getLastIdentifier();
                    int[] identifiers = snmpCurOid.getIdentifiers();
                    identifiers[identifiers.length - 1] = ++lastCurCipher;
                    snmpCurOid.setIdentifiers(identifiers);
                }
            }
            IncludeRange[] includeds = vendors[i].getIncludeRange();
            for (int ji = 0; ji < includeds.length; ++ji) {
                SnmpObjectId snmpBeginOid = new SnmpObjectId(includeds[ji].getBegin());
                SnmpObjectId snmpEndOid = new SnmpObjectId(includeds[ji].getEnd());
                SnmpObjectId rootOid = this.getRootOid(snmpBeginOid);
                if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !rootOid.isRootOf(snmpEndOid)) continue;
                SnmpObjectId snmpCurOid = new SnmpObjectId(snmpBeginOid);
                while (snmpCurOid.compare(snmpEndOid) <= 0) {
                    if (!excludedOids.contains(snmpBeginOid.toString())) {
                        SnmpObjectId oidMask = new SnmpObjectId(snmpBeginOid);
                        oidMask.prepend(curRootSysOid);
                        m_oidMask2className.put(oidMask.toString(), curClassName);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("getClassNames:  adding class " + curClassName + " for oid " + oidMask.toString()));
                        }
                    }
                    int lastCipher = snmpBeginOid.getLastIdentifier();
                    int[] identifiers = snmpBeginOid.getIdentifiers();
                    identifiers[identifiers.length - 1] = ++lastCipher;
                    snmpCurOid.setIdentifiers(identifiers);
                }
            }
        }
    }

    @Override
    public String getClassName(String sysoid) {
        String defaultClassName = null;
        for (String oidMask : m_oidMask2className.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return m_oidMask2className.get(oidMask);
        }
        return defaultClassName;
    }

    @Override
    public boolean hasClassName(String sysoid) {
        for (String oidMask : m_oidMask2className.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return true;
        }
        return false;
    }

    private SnmpObjectId getRootOid(SnmpObjectId snmpObj) {
        int[] identifiers = snmpObj.getIdentifiers();
        int[] rootIdentifiers = new int[identifiers.length - 1];
        for (int i = 0; i < identifiers.length - 1; ++i) {
            rootIdentifiers[i] = identifiers[i];
        }
        return new SnmpObjectId(rootIdentifiers);
    }

    @Override
    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        Category log = this.log();
        boolean filterPassed = false;
        List<String> ipList = m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("interfaceInPackage: Interface " + iface + " passed filter for package " + pkg.getName() + "?: " + filterPassed));
        }
        if (!filterPassed) {
            return false;
        }
        return this.interfaceInPackageRange(iface, pkg);
    }

    @Override
    public synchronized boolean interfaceInPackageRange(String iface, Package pkg) {
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        long addr = IPSorter.convertToLong((String)iface);
        Enumeration eincs = pkg.enumerateIncludeRange();
        while (!has_range_include && eincs.hasMoreElements()) {
            IncludeRange rng = (IncludeRange)eincs.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_include = true;
                continue;
            }
            if (addr != start) continue;
            has_range_include = true;
        }
        Enumeration espec = pkg.enumerateSpecific();
        while (!has_specific && espec.hasMoreElements()) {
            long speca = IPSorter.convertToLong((String)((String)espec.nextElement()));
            if (speca != addr) continue;
            has_specific = true;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        Enumeration eex = pkg.enumerateExcludeRange();
        while (!has_range_exclude && !has_specific && eex.hasMoreElements()) {
            ExcludeRange rng = (ExcludeRange)eex.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_exclude = true;
                continue;
            }
            if (addr != start) continue;
            has_range_exclude = true;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    @Deprecated
    protected synchronized void reloadXML(Reader reader) throws MarshalException, ValidationException, IOException {
        m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (Reader)reader);
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.getClassNames();
    }

    protected synchronized void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (InputStream)stream);
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.getClassNames();
    }

    @Override
    public synchronized void save() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        this.saveXml(stringWriter.toString());
        this.update();
    }

    @Override
    public List<SnmpCollection> getSnmpCollections(String ipaddr, String sysoid) {
        ArrayList<SnmpCollection> snmpcolls = new ArrayList<SnmpCollection>();
        Iterator<String> ite = this.getAllPackageMatches(ipaddr).iterator();
        while (ite.hasNext()) {
            snmpcolls.add(this.populateSnmpCollection(this.createCollection(ipaddr), this.getPackage(ite.next()), sysoid));
        }
        return snmpcolls;
    }

    @Override
    public SnmpCollection getSnmpCollection(String ipaddr, String sysoid, String pkgName) {
        Iterator<String> ite = this.getAllPackageMatches(ipaddr).iterator();
        while (ite.hasNext()) {
            if (!ite.next().equals(pkgName)) continue;
            return this.populateSnmpCollection(this.createCollection(ipaddr), this.getPackage(pkgName), sysoid);
        }
        return null;
    }

    private SnmpCollection createCollection(String ipaddr) {
        SnmpCollection coll = null;
        try {
            coll = new SnmpCollection(SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(ipaddr)));
        }
        catch (Throwable t) {
            this.log().error((Object)("getSnmpCollection: Failed to load snmpcollection parameter from snmp configuration file " + t));
        }
        return coll;
    }

    private SnmpCollection populateSnmpCollection(SnmpCollection coll, Package pkg, String sysoid) {
        coll.setPackageName(pkg.getName());
        coll.setInitialSleepTime(this.getInitialSleepTime());
        if (pkg.hasSnmp_poll_interval()) {
            coll.setPollInterval(pkg.getSnmp_poll_interval());
        } else {
            coll.setPollInterval(this.getSnmpPollInterval());
        }
        if (pkg.hasEnableVlanDiscovery() && pkg.getEnableVlanDiscovery() && this.hasClassName(sysoid)) {
            coll.setVlanClass(this.getClassName(sysoid));
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("populateSnmpCollection: found class to get Vlans: " + coll.getVlanClass()));
            }
        } else if (!pkg.hasEnableVlanDiscovery() && this.enableVlanDiscovery() && this.hasClassName(sysoid)) {
            coll.setVlanClass(this.getClassName(sysoid));
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("populateSnmpCollection: found class to get Vlans: " + coll.getVlanClass()));
            }
        } else if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("populateSnmpCollection: no class found to get Vlans or VlanDiscoveryDisabled for Package: " + pkg.getName()));
        }
        if (pkg.hasUseCdpDiscovery()) {
            coll.collectCdpTable(pkg.getUseCdpDiscovery());
        } else {
            coll.collectCdpTable(this.useCdpDiscovery());
        }
        boolean condition1 = false;
        boolean condition2 = false;
        condition1 = pkg.hasUseIpRouteDiscovery() ? pkg.getUseIpRouteDiscovery() : this.useIpRouteDiscovery();
        condition2 = pkg.hasSaveRouteTable() ? pkg.getSaveRouteTable() : this.saveRouteTable();
        coll.SaveIpRouteTable(condition2);
        coll.collectIpRouteTable(condition1 || condition2);
        condition1 = pkg.hasUseBridgeDiscovery() ? pkg.getUseBridgeDiscovery() : this.useBridgeDiscovery();
        coll.collectBridgeForwardingTable(condition1);
        condition2 = pkg.hasSaveStpNodeTable() ? pkg.getSaveStpNodeTable() : this.saveStpNodeTable();
        coll.saveStpNodeTable(condition2);
        coll.collectStpNode(condition1 || condition2);
        condition2 = pkg.hasSaveStpInterfaceTable() ? pkg.getSaveStpInterfaceTable() : this.saveStpInterfaceTable();
        coll.saveStpInterfaceTable(condition2);
        coll.collectStpTable(condition1 || condition2);
        return coll;
    }

    @Override
    public synchronized Package getFirstPackageMatch(String ipaddr) {
        for (Package pkg : m_config.getPackageCollection()) {
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public synchronized List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : m_config.getPackageCollection()) {
            String pkgName = pkg.getName();
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            matchingPkgs.add(pkgName);
        }
        return matchingPkgs;
    }

    @Override
    public Enumeration<Package> enumeratePackage() {
        return this.getConfiguration().enumeratePackage();
    }

    @Override
    public DiscoveryLink getDiscoveryLink(String pkgName) {
        DiscoveryLink discoveryLink = new DiscoveryLink();
        Package pkg = this.getPackage(pkgName);
        discoveryLink.setPackageName(pkg.getName());
        if (pkg.hasSnmp_poll_interval()) {
            discoveryLink.setSnmpPollInterval(pkg.getSnmp_poll_interval());
        } else {
            discoveryLink.setSnmpPollInterval(this.getSnmpPollInterval());
        }
        if (pkg.hasDiscovery_link_interval()) {
            discoveryLink.setDiscoveryInterval(pkg.getDiscovery_link_interval());
        } else {
            discoveryLink.setDiscoveryInterval(this.getDiscoveryLinkInterval());
        }
        discoveryLink.setInitialSleepTime(this.getInitialSleepTime());
        if (pkg.hasUseBridgeDiscovery()) {
            discoveryLink.setDiscoveryUsingBridge(pkg.getUseBridgeDiscovery());
        } else {
            discoveryLink.setDiscoveryUsingBridge(this.useBridgeDiscovery());
        }
        if (pkg.hasUseCdpDiscovery()) {
            discoveryLink.setDiscoveryUsingCdp(pkg.getUseCdpDiscovery());
        } else {
            discoveryLink.setDiscoveryUsingCdp(this.useCdpDiscovery());
        }
        if (pkg.hasUseIpRouteDiscovery()) {
            discoveryLink.setDiscoveryUsingCdp(pkg.getUseIpRouteDiscovery());
        } else {
            discoveryLink.setDiscoveryUsingRoutes(this.useIpRouteDiscovery());
        }
        if (pkg.hasEnableDiscoveryDownload()) {
            discoveryLink.setEnableDownloadDiscovery(pkg.getEnableDiscoveryDownload());
        } else {
            discoveryLink.setEnableDownloadDiscovery(this.enableDiscoveryDownload());
        }
        if (pkg.hasForceIpRouteDiscoveryOnEthernet()) {
            discoveryLink.setForceIpRouteDiscoveryOnEtherNet(pkg.getForceIpRouteDiscoveryOnEthernet());
        } else {
            discoveryLink.setForceIpRouteDiscoveryOnEtherNet(this.forceIpRouteDiscoveryOnEthernet());
        }
        return discoveryLink;
    }

    private boolean forceIpRouteDiscoveryOnEthernet() {
        boolean forceIpRouteDiscoveryOnEthernet = false;
        if (m_config.hasForceIpRouteDiscoveryOnEthernet()) {
            forceIpRouteDiscoveryOnEthernet = m_config.getForceIpRouteDiscoveryOnEthernet();
        }
        return forceIpRouteDiscoveryOnEthernet;
    }
}

